/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.ride;

import com.github.tartaricacid.touhoulittlemaid.api.entity.fishing.IFishingType;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.fishing.FishingTypeManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class MaidRideFindWaterTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 100;
    private final int verticalSearchRange;
    private final int searchRange;
    protected int verticalSearchStart;
    private IFishingType fishingType = null;
    private class_2338 waterPos = null;

    public MaidRideFindWaterTask(int searchRange, int verticalSearchRange) {
        super((Map<class_4140<?>, class_4141>)ImmutableMap.of());
        this.searchRange = searchRange;
        this.verticalSearchRange = verticalSearchRange;
        this.setMaxCheckRate(100);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        return super.checkExtraStartConditions(worldIn, owner) && owner.fishing == null;
    }

    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        class_1799 mainHandItem = maid.method_6047();
        this.fishingType = FishingTypeManager.getFishingType(mainHandItem);
        if (this.fishingType.isFishingRod(mainHandItem)) {
            if (this.waterPos == null) {
                this.searchForDestination(worldIn, maid, mainHandItem);
                return;
            }
            if (!this.posCheck(maid)) {
                this.waterPos = null;
                return;
            }
            if (this.fishingType.suitableFishingHook(maid, (class_1937)worldIn, mainHandItem, this.waterPos)) {
                class_243 centerPos = class_243.method_24953((class_2382)this.waterPos);
                MaidFishingHook fishingHook = this.fishingType.getFishingHook(maid, (class_1937)worldIn, mainHandItem, centerPos);
                worldIn.method_8649((class_1297)fishingHook);
                worldIn.method_43128(null, maid.method_23317(), maid.method_23318(), maid.method_23321(), class_3417.field_14596, class_3419.field_15254, 0.5f, 0.4f / (worldIn.method_8409().method_43057() * 0.4f + 0.8f));
                maid.method_6104(class_1268.field_5808);
                maid.method_5988().method_19615(centerPos);
            } else {
                this.waterPos = null;
            }
        }
    }

    protected final void searchForDestination(class_3218 worldIn, EntityMaid maid, class_1799 rod) {
        class_2338 centrePos = maid.getBrainSearchPos();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int y = this.verticalSearchStart;
        while (y <= this.verticalSearchRange) {
            for (int i = 0; i < this.searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        mutableBlockPos.method_25504((class_2382)centrePos, x, y - 1, z);
                        if (maid.method_18407((class_2338)mutableBlockPos) && this.fishingType.suitableFishingHook(maid, (class_1937)worldIn, rod, (class_2338)mutableBlockPos)) {
                            maid.method_5988().method_20248((double)mutableBlockPos.method_10263(), (double)mutableBlockPos.method_10264(), (double)mutableBlockPos.method_10260());
                            this.waterPos = mutableBlockPos;
                            this.setNextCheckTickCount(5);
                            return;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
    }

    private boolean posCheck(EntityMaid maid) {
        int distanceSqr = this.searchRange * this.searchRange;
        class_243 waterVec = new class_243((double)this.waterPos.method_10263(), (double)this.waterPos.method_10264(), (double)this.waterPos.method_10260());
        return maid.method_5707(waterVec) < (double)distanceSqr && maid.method_18407(this.waterPos);
    }
}

