/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.RangedWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.IMaidMeal;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.meal.MaidMealManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class MaidHomeMealTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 50;
    @Nullable
    private TileEntityPicnicMat tmpPicnicMat = null;
    private long handFullBubbleKey = -1L;
    private long mealEmptyBubbleKey = -1L;

    public MaidHomeMealTask() {
        super((Map<class_4140<?>, class_4141>)ImmutableMap.of());
        this.setMaxCheckRate(50);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 serverLevel, EntityMaid maid) {
        class_2338 blockPos;
        class_2586 class_25862;
        EntitySit sit;
        if (!super.checkExtraStartConditions(serverLevel, maid)) {
            return false;
        }
        if (!maid.getFavorabilityManager().canAdd(Type.HOME_MEAL.getTypeName())) {
            return false;
        }
        class_1297 class_12972 = maid.method_5854();
        if (class_12972 instanceof EntitySit && (sit = (EntitySit)class_12972).getJoyType().equals(Type.ON_HOME_MEAL.getTypeName()) && (class_25862 = serverLevel.method_8321(blockPos = sit.getAssociatedBlockPos())) instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMat;
            this.tmpPicnicMat = picnicMat = (TileEntityPicnicMat)class_25862;
            return true;
        }
        return false;
    }

    protected void start(class_3218 serverLevel, EntityMaid maid, long gameTime) {
        class_1799 handItemCopy;
        if (this.tmpPicnicMat == null) {
            return;
        }
        List<IMaidMeal> maidMeals = MaidMealManager.getMaidMeals(MaidMealType.HOME_MEAL);
        class_1268 eanHand = class_1268.field_5810;
        for (class_1268 hand : class_1268.values()) {
            if (!maid.method_5998(hand).method_7960()) continue;
            eanHand = hand;
            break;
        }
        class_1799 itemInHand = maid.method_5998(eanHand);
        RangedWrapper availableInv = maid.getAvailableBackpackInv();
        class_1799 leftoverStack = ItemHandlerHelper.insertItemStacked(availableInv, handItemCopy = itemInHand.method_7972(), true);
        if (!leftoverStack.method_7960()) {
            this.handFullBubbleKey = maid.getChatBubbleManager().addTextChatBubbleIfTimeout("chat_bubble.touhou_little_maid.inner.home_meal.two_hand_is_full", this.handFullBubbleKey);
            return;
        }
        ItemStackHandler handler = this.tmpPicnicMat.getHandler();
        IntArrayList candidateFood = new IntArrayList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            class_1799 stack = handler.getStackInSlot(i);
            if (stack.method_7960()) continue;
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, stack, eanHand)) continue;
                candidateFood.add(i);
            }
        }
        int size = candidateFood.size();
        if (size == 0) {
            this.mealEmptyBubbleKey = maid.getChatBubbleManager().addTextChatBubbleIfTimeout("chat_bubble.touhou_little_maid.inner.home_meal.meal_is_empty", this.mealEmptyBubbleKey);
            return;
        }
        int skipCount = maid.method_6051().method_43048(size);
        class_1268 hand = eanHand;
        candidateFood.intStream().skip(skipCount).findFirst().ifPresent(slotIndex -> {
            class_1799 outputStack = handler.extractItem(slotIndex, 1, false);
            this.tmpPicnicMat.refresh();
            maid.method_6122(hand, outputStack);
            class_1799 refreshItemInHand = maid.method_5998(hand);
            for (IMaidMeal maidMeal : maidMeals) {
                if (!maidMeal.canMaidEat(maid, refreshItemInHand, hand)) continue;
                maid.memoryHandItemStack(handItemCopy);
                maidMeal.onMaidEat(maid, refreshItemInHand, hand);
                class_1309 patt0$temp = maid.method_35057();
                if (patt0$temp instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)patt0$temp;
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_picnic_eat");
                }
                return;
            }
        });
    }

    protected void stop(class_3218 pLevel, EntityMaid pEntity, long pGameTime) {
        this.tmpPicnicMat = null;
    }
}

