/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.FenceGateBlockAccessor;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_7893;
import net.minecraft.class_7898;
import net.minecraft.class_7906;
import net.minecraft.class_9;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class MaidInteractWithDoor {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 3;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 8.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;

    public static class_7893<class_1309> create() {
        MutableObject mutableObject = new MutableObject();
        MutableInt mutableInt = new MutableInt();
        return class_7898.method_47224(instance -> instance.group((App)instance.method_47244(class_4140.field_18449), (App)instance.method_47235(class_4140.field_26389), (App)instance.method_47235(class_4140.field_18441)).apply((Applicative)instance, (pathMemory, doorToCloseMemory, livingEntityMemory) -> (serverLevel, entity, time) -> {
            class_11 path = (class_11)instance.method_47243(pathMemory);
            Optional<Set<class_4208>> doorToClosePos = instance.method_47233(doorToCloseMemory);
            if (!path.method_30849() && !path.method_46()) {
                EntityMaid maid;
                EntityMaid maid2;
                if (Objects.equals(mutableObject.getValue(), path.method_29301())) {
                    mutableInt.setValue(3);
                } else if (mutableInt.decrementAndGet() > 0) {
                    return false;
                }
                boolean canOpenDoor = entity instanceof EntityMaid && (maid2 = (EntityMaid)entity).getConfigManager().isOpenDoor();
                boolean canOpenFenceGate = entity instanceof EntityMaid && (maid = (EntityMaid)entity).getConfigManager().isOpenFenceGate();
                mutableObject.setValue((Object)path.method_29301());
                class_9 previousNode = path.method_30850();
                class_9 nextNode = path.method_29301();
                class_2338 previousNodeBlockPos = previousNode.method_22879();
                class_2680 previousNodeBlockState = serverLevel.method_8320(previousNodeBlockPos);
                if (canOpenDoor && previousNodeBlockState.method_27851(class_3481.field_15494, stateBase -> stateBase.method_26204() instanceof class_2323)) {
                    class_2323 doorBlock = (class_2323)previousNodeBlockState.method_26204();
                    if (!doorBlock.method_30841(previousNodeBlockState)) {
                        doorBlock.method_10033((class_1297)entity, (class_1937)serverLevel, previousNodeBlockState, previousNodeBlockPos, true);
                    }
                    doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((class_7906<OptionalBox.Mu, Set<class_4208>>)doorToCloseMemory, doorToClosePos, serverLevel, previousNodeBlockPos);
                } else if (canOpenFenceGate && previousNodeBlockState.method_27851(class_3481.field_25147, stateBase -> stateBase.method_26204() instanceof class_2349)) {
                    if (!((Boolean)previousNodeBlockState.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
                        MaidInteractWithDoor.setFenceGate((class_1297)entity, (class_1937)serverLevel, previousNodeBlockState, previousNodeBlockPos, true);
                    }
                    doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((class_7906<OptionalBox.Mu, Set<class_4208>>)doorToCloseMemory, doorToClosePos, serverLevel, previousNodeBlockPos);
                }
                class_2338 nextNodeBlockPos = nextNode.method_22879();
                class_2680 nextNodeBlockState = serverLevel.method_8320(nextNodeBlockPos);
                if (canOpenDoor && nextNodeBlockState.method_27851(class_3481.field_15494, stateBase -> stateBase.method_26204() instanceof class_2323)) {
                    class_2323 doorBlock = (class_2323)nextNodeBlockState.method_26204();
                    if (!doorBlock.method_30841(nextNodeBlockState)) {
                        doorBlock.method_10033((class_1297)entity, (class_1937)serverLevel, nextNodeBlockState, nextNodeBlockPos, true);
                        doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((class_7906<OptionalBox.Mu, Set<class_4208>>)doorToCloseMemory, doorToClosePos, serverLevel, nextNodeBlockPos);
                    }
                } else if (canOpenFenceGate && nextNodeBlockState.method_27851(class_3481.field_25147, stateBase -> stateBase.method_26204() instanceof class_2349) && !((Boolean)nextNodeBlockState.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
                    MaidInteractWithDoor.setFenceGate((class_1297)entity, (class_1937)serverLevel, nextNodeBlockState, nextNodeBlockPos, true);
                    doorToClosePos = MaidInteractWithDoor.rememberDoorToClose((class_7906<OptionalBox.Mu, Set<class_4208>>)doorToCloseMemory, doorToClosePos, serverLevel, nextNodeBlockPos);
                }
                doorToClosePos.ifPresent(doorPos -> MaidInteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(serverLevel, entity, previousNode, nextNode, doorPos, instance.method_47233(livingEntityMemory)));
                return true;
            }
            return false;
        }));
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(class_3218 serverLevel, class_1309 entity, @Nullable class_9 previous, @Nullable class_9 next, Set<class_4208> doorPositions, Optional<List<class_1309>> nearestLivingEntities) {
        Iterator<class_4208> doorPosIterator = doorPositions.iterator();
        while (doorPosIterator.hasNext()) {
            class_4208 globalPos = doorPosIterator.next();
            class_2338 blockPos = globalPos.method_19446();
            if (previous != null && previous.method_22879().equals((Object)blockPos) && (next == null || !entity.method_24515().equals((Object)next.method_22879())) || next != null && next.method_22879().equals((Object)blockPos)) continue;
            if (MaidInteractWithDoor.isDoorTooFarAway(serverLevel, entity, globalPos)) {
                doorPosIterator.remove();
                continue;
            }
            class_2680 blockstate = serverLevel.method_8320(blockPos);
            if (blockstate.method_27851(class_3481.field_15494, stateBase -> stateBase.method_26204() instanceof class_2323)) {
                class_2323 doorblock = (class_2323)blockstate.method_26204();
                if (!doorblock.method_30841(blockstate)) {
                    doorPosIterator.remove();
                    continue;
                }
                if (MaidInteractWithDoor.areOtherMobsComingThroughDoor(entity, blockPos, nearestLivingEntities)) {
                    doorPosIterator.remove();
                    continue;
                }
                doorblock.method_10033((class_1297)entity, (class_1937)serverLevel, blockstate, blockPos, false);
                doorPosIterator.remove();
                continue;
            }
            if (blockstate.method_27851(class_3481.field_25147, stateBase -> stateBase.method_26204() instanceof class_2349)) {
                if (!((Boolean)blockstate.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
                    doorPosIterator.remove();
                    continue;
                }
                if (MaidInteractWithDoor.areOtherMobsComingThroughDoor(entity, blockPos, nearestLivingEntities)) {
                    doorPosIterator.remove();
                    continue;
                }
                MaidInteractWithDoor.setFenceGate((class_1297)entity, (class_1937)serverLevel, blockstate, blockPos, false);
                continue;
            }
            doorPosIterator.remove();
        }
    }

    private static boolean areOtherMobsComingThroughDoor(class_1309 entity, class_2338 pos, Optional<List<class_1309>> nearestLivingEntities) {
        return nearestLivingEntities.map(entities -> entities.stream().filter(livingEntity -> livingEntity.method_5864() == entity.method_5864()).filter(livingEntity -> pos.method_19769((class_2374)livingEntity.method_19538(), 2.0)).anyMatch(livingEntity -> MaidInteractWithDoor.isMobComingThroughDoor(livingEntity.method_18868(), pos))).orElse(false);
    }

    private static boolean isMobComingThroughDoor(class_4095<?> brain, class_2338 pos) {
        if (!brain.method_18896(class_4140.field_18449)) {
            return false;
        }
        class_11 path = (class_11)brain.method_18904(class_4140.field_18449).get();
        if (path.method_46()) {
            return false;
        }
        class_9 previousNode = path.method_30850();
        if (previousNode == null) {
            return false;
        }
        class_9 nextNode = path.method_29301();
        return pos.equals((Object)previousNode.method_22879()) || pos.equals((Object)nextNode.method_22879());
    }

    private static boolean isDoorTooFarAway(class_3218 level, class_1309 entity, class_4208 pos) {
        return pos.method_19442() != level.method_27983() || !pos.method_19446().method_19769((class_2374)entity.method_19538(), 8.0);
    }

    private static Optional<Set<class_4208>> rememberDoorToClose(class_7906<OptionalBox.Mu, Set<class_4208>> doorsToClose, Optional<Set<class_4208>> doorPositions, class_3218 level, class_2338 blockPos) {
        class_4208 globalPos = class_4208.method_19443((class_5321)level.method_27983(), (class_2338)blockPos);
        return Optional.of(doorPositions.map(pos -> {
            pos.add(globalPos);
            return pos;
        }).orElseGet(() -> {
            HashSet posSet = Sets.newHashSet((Object[])new class_4208[]{globalPos});
            doorsToClose.method_47249((Object)posSet);
            return posSet;
        }));
    }

    private static void setFenceGate(@Nullable class_1297 entity, class_1937 serverLevel, class_2680 blockstate, class_2338 blockPos, boolean isOpen) {
        serverLevel.method_8652(blockPos, (class_2680)blockstate.method_11657((class_2769)class_2349.field_11026, (Comparable)Boolean.valueOf(isOpen)), 10);
        class_2248 class_22482 = blockstate.method_26204();
        if (class_22482 instanceof FenceGateBlockAccessor) {
            FenceGateBlockAccessor fenceGateBlock = (FenceGateBlockAccessor)class_22482;
            class_3414 openSound = fenceGateBlock.tlm$getType().comp_1304();
            class_3414 closeSound = fenceGateBlock.tlm$getType().comp_1303();
            serverLevel.method_45445(entity, blockPos, isOpen ? openSound : closeSound, class_3419.field_15245, 1.0f, serverLevel.method_8409().method_43057() * 0.1f + 0.9f);
        }
        serverLevel.method_33596(entity, isOpen ? class_5712.field_28168 : class_5712.field_28169, blockPos);
    }
}

