/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack.data;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3861;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class FurnaceBackpackData
extends class_1277
implements IBackpackData {
    private static final int INPUT_INDEX = 0;
    private static final int FUEL_INDEX = 1;
    private static final int OUTPUT_INDEX = 2;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private final class_1863.class_7266<class_1263, class_3861> quickCheck;
    private final class_1937 level;
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> FurnaceBackpackData.this.litTime;
                case 1 -> FurnaceBackpackData.this.litDuration;
                case 2 -> FurnaceBackpackData.this.cookingProgress;
                case 3 -> FurnaceBackpackData.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    FurnaceBackpackData.this.litTime = value;
                    break;
                }
                case 1: {
                    FurnaceBackpackData.this.litDuration = value;
                    break;
                }
                case 2: {
                    FurnaceBackpackData.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    FurnaceBackpackData.this.cookingTotalTime = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };

    public FurnaceBackpackData(EntityMaid maid) {
        super(3);
        this.quickCheck = class_1863.method_42302((class_3956)class_3956.field_17546);
        this.level = maid.field_6002;
    }

    @Override
    public class_3913 getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void load(class_2487 tag, EntityMaid maid) {
        this.litTime = tag.method_10550("BurnTime");
        this.cookingProgress = tag.method_10550("CookTime");
        this.cookingTotalTime = tag.method_10550("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.method_5438(1));
        this.method_7659(tag.method_10554("Items", 10));
    }

    @Override
    public void save(class_2487 tag, EntityMaid maid) {
        tag.method_10569("BurnTime", this.litTime);
        tag.method_10569("CookTime", this.cookingProgress);
        tag.method_10569("CookTimeTotal", this.cookingTotalTime);
        tag.method_10566("Items", (class_2520)this.method_7660());
    }

    @Override
    public void serverTick(EntityMaid maid) {
        boolean readyForLit;
        class_1937 level = maid.method_37908();
        if (this.isLit()) {
            --this.litTime;
        }
        class_1799 fuelItem = this.method_5438(1);
        boolean inputNotEmpty = !this.method_5438(0).method_7960();
        boolean fuelNotEmpty = !fuelItem.method_7960();
        boolean bl = readyForLit = inputNotEmpty && fuelNotEmpty;
        if (this.isLit() || readyForLit) {
            class_3861 recipe = null;
            if (inputNotEmpty) {
                recipe = this.quickCheck.method_42303((class_1263)this, level).orElse(null);
            }
            int maxStackSize = this.method_5444();
            if (!this.isLit() && this.canBurn(level.method_30349(), recipe, this, maxStackSize)) {
                this.litDuration = this.litTime = this.getBurnDuration(fuelItem);
                if (this.isLit()) {
                    if (fuelItem.method_7909().method_7858() != null) {
                        this.method_5447(1, new class_1799((class_1935)fuelItem.method_7909().method_7858()));
                    } else if (fuelNotEmpty) {
                        fuelItem.method_7934(1);
                        if (fuelItem.method_7960()) {
                            this.method_5447(1, new class_1799((class_1935)fuelItem.method_7909().method_7858()));
                        }
                    }
                }
            }
            if (this.isLit() && this.canBurn(level.method_30349(), recipe, this, maxStackSize)) {
                ++this.cookingProgress;
                if (this.cookingProgress == this.cookingTotalTime) {
                    this.cookingProgress = 0;
                    this.cookingTotalTime = this.getTotalCookTime(level);
                    if (this.burn(level.method_30349(), recipe, this, maxStackSize)) {
                        int exp = this.createExperience(recipe.method_8171());
                        maid.setExperience(maid.getExperience() + exp);
                    }
                }
            } else {
                this.cookingProgress = 0;
            }
        } else if (this.cookingProgress > 0) {
            this.cookingProgress = class_3532.method_15340((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
        }
    }

    public void method_5447(int index, class_1799 stack) {
        class_1799 slotItem = this.method_5438(index);
        boolean isSameItem = !stack.method_7960() && class_1799.method_31577((class_1799)slotItem, (class_1799)stack);
        super.method_5447(index, stack);
        if (index == 0 && !isSameItem) {
            this.cookingTotalTime = this.getTotalCookTime(this.level);
            this.cookingProgress = 0;
        }
    }

    private int createExperience(float recipeExp) {
        int integer = class_3532.method_15375((float)recipeExp);
        float decimal = class_3532.method_22450((float)recipeExp);
        if (decimal != 0.0f && Math.random() < (double)decimal) {
            ++integer;
        }
        return integer;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    private int getBurnDuration(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)fuel.method_7909());
        return burnTime == null ? 0 : burnTime;
    }

    private boolean canBurn(class_5455 access, @Nullable class_3861 recipe, class_1277 container, int maxStackSize) {
        if (!container.method_5438(0).method_7960() && recipe != null) {
            class_1799 result = recipe.method_8116((class_1263)this, access);
            if (result.method_7960()) {
                return false;
            }
            class_1799 output = container.method_5438(2);
            if (output.method_7960()) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)output, (class_1799)result)) {
                return false;
            }
            if (output.method_7947() + result.method_7947() <= maxStackSize && output.method_7947() + result.method_7947() <= output.method_7914()) {
                return true;
            }
            return output.method_7947() + result.method_7947() <= result.method_7914();
        }
        return false;
    }

    private boolean burn(class_5455 access, @Nullable class_3861 recipe, class_1277 container, int maxStackSize) {
        if (recipe != null && this.canBurn(access, recipe, container, maxStackSize)) {
            class_1799 input = container.method_5438(0);
            class_1799 result = recipe.method_8116((class_1263)this, access);
            class_1799 output = container.method_5438(2);
            if (output.method_7960()) {
                container.method_5447(2, result.method_7972());
            } else if (output.method_31574(result.method_7909())) {
                output.method_7933(result.method_7947());
            }
            if (input.method_31574(class_2246.field_10562.method_8389()) && !container.method_5438(1).method_7960() && container.method_5438(1).method_31574(class_1802.field_8550)) {
                container.method_5447(1, new class_1799((class_1935)class_1802.field_8705));
            }
            input.method_7934(1);
            return true;
        }
        return false;
    }

    private int getTotalCookTime(class_1937 level) {
        return this.quickCheck.method_42303((class_1263)this, level).map(class_1874::method_8167).orElse(200);
    }
}

