package cn.sh1rocu.touhoulittlemaid.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1937;

public class EntityMountEvent extends CancellableEvent {
    private final class_1297 entityMounting;
    private final class_1297 entityBeingMounted;
    private final class_1937 level;
    private final boolean isMounting;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (final Callback callback : callbacks)
            callback.post(event);
    });

    public EntityMountEvent(class_1297 entityMounting, class_1297 entityBeingMounted, class_1937 level, boolean isMounting) {
        this.entityMounting = entityMounting;
        this.entityBeingMounted = entityBeingMounted;
        this.level = level;
        this.isMounting = isMounting;
    }

    public boolean isMounting() {
        return isMounting;
    }

    public boolean isDismounting() {
        return !isMounting;
    }

    public class_1297 getEntityMounting() {
        return entityMounting;
    }

    public class_1297 getEntityBeingMounted() {
        return entityBeingMounted;
    }

    public class_1937 getLevel() {
        return level;
    }

    public interface Callback {
        void post(EntityMountEvent event);
    }
}