package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.WirelessIOSlotButton;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.network.message.WirelessIOSlotConfigPackage;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.commons.compress.utils.Lists;

import java.util.List;

public class WirelessIOConfigSlotGui extends class_437 {
    private static final class_2960 SLOT = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/wireless_io_slot_config.png");
    private static final int SLOT_NUM = 38;
    private List<Boolean> configData;
    protected int imageWidth = 155;
    protected int imageHeight = 160;
    protected int leftPos;
    protected int topPos;

    protected WirelessIOConfigSlotGui(class_1799 wirelessIO) {
        super(class_2561.method_43470("Wireless IO Config Slot GUI"));
        configData = ItemWirelessIO.getSlotConfig(wirelessIO);
        if (configData == null) {
            configData = Lists.newArrayList();
        }
        int configDataSize = configData.size();
        if (configDataSize < SLOT_NUM) {
            for (int i = configDataSize; i < SLOT_NUM; i++) {
                configData.add(false);
            }
        }
    }

    @Override
    protected void method_25426() {
        this.method_37067();

        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;

        int index = 0;
        for (int col = 0; col < 6; col++) {
            WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 8 + 18 * col, topPos + 8, 16, 16, configData);
            button.initTextureValues(158, 0, 16, 16, SLOT);
            method_37063(button);
            index++;
        }

        for (int col = 0; col < 6; col++) {
            WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 8 + 18 * col, topPos + 30, 16, 16, configData);
            button.initTextureValues(158, 0, 16, 16, SLOT);
            method_37063(button);
            index++;
        }

        for (int row = 0; row < 2; row++) {
            for (int col = 0; col < 6; col++) {
                WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 8 + 18 * col, topPos + 53 + 18 * row, 16, 16, configData);
                button.initTextureValues(158, 0, 16, 16, SLOT);
                method_37063(button);
                index++;
            }
        }

        for (int row = 0; row < 2; row++) {
            for (int col = 0; col < 6; col++) {
                WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 8 + 18 * col, topPos + 94 + 18 * row, 16, 16, configData);
                button.initTextureValues(158, 0, 16, 16, SLOT);
                method_37063(button);
                index++;
            }
        }

        for (int row = 0; row < 2; row++) {
            WirelessIOSlotButton button = new WirelessIOSlotButton(index, leftPos + 131, topPos + 8 + 18 * row, 16, 16, configData);
            button.initTextureValues(158, 0, 16, 16, SLOT);
            method_37063(button);
            index++;
        }

        class_4185 confirm = class_4185.method_46430(class_2561.method_43471("gui.done"), b -> ClientPlayNetworking.send(new WirelessIOSlotConfigPackage(this.configData)))
                .method_46433(leftPos, topPos + 140).method_46437(60, 20).method_46431();
        class_4185 cancel = class_4185.method_46430(class_2561.method_43471("gui.cancel"), b -> ClientPlayNetworking.send(new WirelessIOSlotConfigPackage()))
                .method_46433(leftPos + 62, topPos + 140).method_46437(60, 20).method_46431();
        method_37063(confirm);
        method_37063(cancel);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(graphics, mouseX, mouseY, partialTicks);
        for (class_4068 renderable : ((ScreenAccessor) this).tlm$getRenderables()) {
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void renderBg(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_25302(SLOT, leftPos, topPos, 0, 0, imageWidth, imageHeight);
    }
}
