package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class MaidUseShieldTask extends class_4097<EntityMaid> {
    private static final int CHECK_RANGE = 8;

    public MaidUseShieldTask() {
        super(ImmutableMap.of(class_4140.field_22355, class_4141.field_18458));
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 serverLevel, EntityMaid maid) {
        // 盾牌优先判断，节省性能
        if (!maid.canUseShield()) {
            return false;
        }
        class_1309 target = maid.method_5968();
        // 如果敌对生物靠太近，盾牌防御
        return target != null && target.method_5805() && target.method_5739(maid) < CHECK_RANGE;
    }

    @Override
    protected boolean canStillUse(class_3218 serverLevel, EntityMaid maid, long gameTime) {
        return this.checkExtraStartConditions(serverLevel, maid);
    }

    @Override
    protected void start(class_3218 serverLevel, EntityMaid maid, long gameTime) {
        maid.method_6019(class_1268.field_5810);
    }

    @Override
    protected void stop(class_3218 serverLevel, EntityMaid maid, long gameTime) {
        maid.method_6021();
    }
}
