package com.github.tartaricacid.touhoulittlemaid.entity.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.CropBlockAccessor;
import net.minecraft.class_1794;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2421;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5712;
import net.minecraft.class_6088;
import net.minecraft.world.level.block.*;

public class TaskNormalFarm implements IFarmTask {
    private static final class_2960 NAME = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "farm");

    @Override
    public class_2960 getUid() {
        return NAME;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8609.method_7854();
    }

    @Override
    public boolean isSeed(class_1799 stack) {
        // 自己新建一个 tag 用了存储可种的种子
        return stack.method_31573(TagItem.MAID_PLANTABLE_SEEDS) && stack.method_7909() instanceof class_1798;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        class_2248 block = cropState.method_26204();
        if (block instanceof class_2302 cropBlock && cropBlock.method_9825(cropState)) {
            return true;
        }
        return block == class_2246.field_9974 && cropState.method_11654(class_2421.field_11306) >= 3;
    }

    @Override
    public void harvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        if (maid.method_6047().method_7909() instanceof class_1794) {
            maid.destroyBlock(cropPos);
        } else {
            CombinedInvWrapper availableInv = maid.getAvailableInv(false);
            class_2248 cropBlock = cropState.method_26204();
            maid.field_6002.method_20290(class_6088.field_31144, cropPos, class_2248.method_9507(cropState));

            if (cropBlock instanceof CropBlockAccessor crop) {
                class_2586 blockEntity = cropState.method_31709() ? maid.field_6002.method_8321(cropPos) : null;
                maid.dropResourcesToMaidInv(cropState, maid.field_6002, cropPos, blockEntity, maid, maid.method_6047());
                // 直接设置 Age 为 0
                if (cropState.method_28498(crop.tlmAgeProperty())) {
                    try {
                        cropState = cropState.method_47968(crop.tlmAgeProperty(), 0);
                    } catch (IllegalArgumentException ignore) {
                    }
                }
                maid.field_6002.method_8652(cropPos, cropState, class_2248.field_31036);
                maid.field_6002.method_33596(maid, class_5712.field_28733, cropPos);
                return;
            }

            if (cropBlock == class_2246.field_9974) {
                class_1799 dropItemStack = new class_1799(class_1802.field_8790);
                class_1799 remindItemStack = ItemHandlerHelper.insertItemStacked(availableInv, dropItemStack, false);
                if (!remindItemStack.method_7960()) {
                    class_2248.method_9577(maid.field_6002, cropPos, remindItemStack);
                }
                maid.field_6002.method_8652(cropPos, class_2246.field_9974.method_9564(), class_2248.field_31036);
                maid.field_6002.method_33596(maid, class_5712.field_28733, cropPos);
            }
        }
    }

    @Override
    public boolean canPlant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        class_2338 abovePos = basePos.method_10084();
        class_2680 aboveState = maid.field_6002.method_8320(abovePos);
        if (!aboveState.method_45474() || aboveState.method_51176()) {
            return false;
        }
        if (seed.method_7909() instanceof class_1798 blockNamedItem) {
            class_2680 plantBlockState = blockNamedItem.method_7711().method_9564();
            return plantBlockState.method_26184(maid.field_6002, abovePos);
        }
        return false;
    }

    @Override
    public class_1799 plant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        maid.placeItemBlock(basePos.method_10084(), seed);
        return seed;
    }
}
