package com.github.tartaricacid.touhoulittlemaid.inventory.container.config;

import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_9135;
import org.jetbrains.annotations.NotNull;

public class MaidConfigContainer extends AbstractMaidContainer {
    public static final class_3917<MaidConfigContainer> TYPE = new ExtendedScreenHandlerType<>(MaidConfigContainer::new, class_9135.field_49675);
    private static final int PLAYER_INVENTORY_SIZE = 27;

    public MaidConfigContainer(int id, class_1661 inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
    }

    public static class_3908 create(int entityId) {
        return new ExtendedScreenHandlerFactory<Integer>() {
            @Override
            public Integer getScreenOpeningData(class_3222 player) {
                return entityId;
            }

            @Override
            public @NotNull class_2561 method_5476() {
                return class_2561.method_43470("Maid Config Container");
            }

            @Override
            public class_1703 createMenu(int index, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                return new MaidConfigContainer(index, playerInventory, entityId);
            }

            @Override
            public boolean shouldCloseCurrentScreen() {
                return false;
            }

/*            @Override
            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }*/
        };
    }

    @Override
    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1799 stack1 = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 stack2 = slot.method_7677();
            stack1 = stack2.method_7972();
            if (index < PLAYER_INVENTORY_SIZE) {
                if (!this.method_7616(stack2, PLAYER_INVENTORY_SIZE, this.field_7761.size(), false)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(stack2, 0, PLAYER_INVENTORY_SIZE, true)) {
                return class_1799.field_8037;
            }
            if (stack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return stack1;
    }
}