package com.github.tartaricacid.touhoulittlemaid.inventory.container.other;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.SlotItemHandler;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPicnicBasket;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class PicnicBasketContainer extends class_1703 {
    public static final class_3917<PicnicBasketContainer> TYPE = new ExtendedScreenHandlerType<>(PicnicBasketContainer::new, class_1799.field_48349);
    private final class_1799 picnicBasket;
    private final ItemStackHandler container;

    public PicnicBasketContainer(int id, class_1661 inventory, class_1799 picnicBasket) {
        super(TYPE, id);
        this.picnicBasket = picnicBasket;
        this.container = ItemPicnicBasket.getContainer(picnicBasket);
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new SlotItemHandler(container, i, 8 + i * 18, 18) {
                @Override
                public boolean method_7680(@NotNull class_1799 stack) {
                    //return stack.getFoodProperties(null) != null;
                    return stack.method_57824(class_9334.field_50075) != null;
                }
            });
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735(inventory, j + i * 9 + 9, 8 + j * 18, 49 + i * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735(inventory, i, 8 + i * 18, 107));
        }
    }

    @Override
    public void method_7593(int slotId, int button, class_1713 clickTypeIn, class_1657 player) {
        // 禁阻一切对当前手持物品的交互，防止刷物品 bug
        if (slotId == 36 + player.method_31548().field_7545) {
            return;
        }
        if (clickTypeIn == class_1713.field_7791) {
            return;
        }
        super.method_7593(slotId, button, clickTypeIn, player);
        ItemPicnicBasket.setContainer(picnicBasket, container);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 output = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 stack = slot.method_7677();
            output = stack.method_7972();
            if (index < 9) {
                if (!this.method_7616(stack, 9, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(stack, 0, 9, false)) {
                return class_1799.field_8037;
            }
            if (stack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return output;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return player.method_6047().method_7909() == InitItems.PICNIC_BASKET;
    }
}
