package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityExtinguishingAgent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8103;

public class FireProtectBauble implements IMaidBauble {
    public FireProtectBauble() {
        MaidDamageEvent.CALLBACK.register(this::onLivingDamage);
    }

    public void onLivingDamage(MaidDamageEvent event) {
        EntityMaid maid = event.getMaid();
        class_1282 source = event.getSource();
        if (source.method_48789(class_8103.field_42246)) {
            int slot = ItemsUtil.getBaubleSlotInMaid(maid, this);
            if (slot >= 0) {
                event.setCanceled(true);
                class_1799 stack = maid.getMaidBauble().getStackInSlot(slot);
                maid.hurtAndBreak(stack, 1);
                maid.getMaidBauble().setStackInSlot(slot, stack);
                maid.method_6092(new class_1293(class_1294.field_5918, 300));
                if (!maid.field_6002.field_9236) {
                    maid.field_6002.method_8649(new EntityExtinguishingAgent(maid.field_6002, maid.method_19538()));
                }
                if (maid.method_35057() instanceof class_3222 serverPlayer) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_PROTECT_BAUBLE);
                }
            }
        }
    }
}
