package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.IPlayerMixin;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public class PlayerMixin implements IPlayerMixin {
    @Unique
    private long removeVehicleTimestamp = -1L;

    @Inject(method = "removeVehicle()V", at = @At("HEAD"))
    private void tlmRemoveVehicle(CallbackInfo ci) {
        removeVehicleTimestamp = class_156.method_658();
    }

    @Override
    public boolean tlmInRemoveVehicleCooldown() {
        // 三秒冷却时间
        return class_156.method_658() - removeVehicleTimestamp < 3000;
    }
}