package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record SetBeaconPotionPackage(class_2338 pos, int potionIndex) implements class_8710 {
    public static final class_8710.class_9154<SetBeaconPotionPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("set_beacon_potion"));
    public static final class_9139<ByteBuf, SetBeaconPotionPackage> STREAM_CODEC = class_9139.method_56435(
            class_2338.field_48404,
            SetBeaconPotionPackage::pos,
            class_9135.field_48550,
            SetBeaconPotionPackage::potionIndex,
            SetBeaconPotionPackage::new
    );

    public static void handle(SetBeaconPotionPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            class_1937 world = sender.method_37908();
            if (world.method_8477(message.pos)) {
                class_2586 te = world.method_8321(message.pos);
                if (te instanceof TileEntityMaidBeacon) {
                    ((TileEntityMaidBeacon) te).setPotionIndex(message.potionIndex);
                }
            }
        });
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
