package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.compat.ysm.event.UpdateRemoteStructEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record SyncYsmMaidDataPackage(int entityId, String rouletteAnim, boolean isRouletteAnimPlaying,
                                     Object2FloatOpenHashMap<String> roamingVars) implements class_8710 {
    public static final class_8710.class_9154<SyncYsmMaidDataPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("sync_ysm_maid_data"));
    public static final class_9139<ByteBuf, SyncYsmMaidDataPackage> STREAM_CODEC = class_9139.method_56905(
            class_9135.field_48550,
            SyncYsmMaidDataPackage::entityId,
            class_9135.field_48554,
            SyncYsmMaidDataPackage::rouletteAnim,
            class_9135.field_48547,
            SyncYsmMaidDataPackage::isRouletteAnimPlaying,
            ByteBufUtils.OBJECT_2_FLOAT_OPEN_HASH_MAP_CODEC,
            SyncYsmMaidDataPackage::roamingVars,
            SyncYsmMaidDataPackage::new
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(SyncYsmMaidDataPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> onHandle(message));
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(SyncYsmMaidDataPackage message) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(message.entityId);
        if (!(entity instanceof EntityMaid maid)) {
            return;
        }
        UpdateRemoteStructEvent.EVENT.invoker().post(new UpdateRemoteStructEvent(maid, message.roamingVars));
        if (message.isRouletteAnimPlaying) {
            maid.playRouletteAnim(message.rouletteAnim);
        } else {
            maid.stopRouletteAnim();
        }
    }
}
