/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public class WirelessIOBauble
implements IMaidBauble {
    private static final int SLOT_NUM = 38;

    @Nonnull
    public static class_1799 insertItemStacked(IItemHandler inventory, @Nonnull class_1799 stack, boolean simulate, @Nullable List<Boolean> slotConfig) {
        int i;
        if (stack.method_7960()) {
            return stack;
        }
        if (!stack.method_7946()) {
            return WirelessIOBauble.insertItem(inventory, stack, simulate, slotConfig);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; i < sizeInventory; ++i) {
            class_1799 slot = inventory.getStackInSlot(i);
            if ((slotConfig == null || i >= slotConfig.size() || !slotConfig.get(i).booleanValue()) && class_1799.method_31577((class_1799)slot, (class_1799)stack) && !slot.method_7960() && slot.method_7946() && (stack = inventory.insertItem(i, stack, simulate)).method_7960()) break;
        }
        if (!stack.method_7960()) {
            for (i = 0; i < sizeInventory && (slotConfig != null && i < slotConfig.size() && slotConfig.get(i).booleanValue() || !inventory.getStackInSlot(i).method_7960() || !(stack = inventory.insertItem(i, stack, simulate)).method_7960()); ++i) {
            }
        }
        return stack;
    }

    public static class_1799 insertItem(IItemHandler dest, @Nonnull class_1799 stack, boolean simulate, @Nullable List<Boolean> slotConfig) {
        if (stack.method_7960()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (slotConfig != null && i < slotConfig.size() && slotConfig.get(i).booleanValue() || !(stack = dest.insertItem(i, stack, simulate)).method_7960()) continue;
            return class_1799.field_8037;
        }
        return stack;
    }

    @Override
    public void onTick(EntityMaid maid, class_1799 baubleItem) {
        if (maid.field_6012 % 100 == 0 && !maid.guiOpening) {
            class_2338 bindingPos = ItemWirelessIO.getBindingPos(baubleItem);
            if (bindingPos == null) {
                return;
            }
            float maxDistance = maid.method_18413();
            if (maid.method_5649(bindingPos.method_10263(), bindingPos.method_10264(), bindingPos.method_10260()) > (double)(maxDistance * maxDistance)) {
                return;
            }
            class_2586 te = maid.field_6002.method_8321(bindingPos);
            if (te == null) {
                return;
            }
            for (IChestType type : ChestManager.getAllChestTypes()) {
                class_1309 class_13092;
                if (!type.isChest(te)) continue;
                int openCount = type.getOpenCount((class_1922)maid.field_6002, bindingPos, te);
                if (openCount > 0) {
                    return;
                }
                Storage chestInv = (Storage)ItemStorage.SIDED.find(maid.field_6002, te.method_11016(), te.method_11010(), te, null);
                if (chestInv != null) {
                    ArrayList<Boolean> slotConfigData;
                    CombinedInvWrapper maidInv = maid.getAvailableInv(false);
                    boolean isMaidToChest = ItemWirelessIO.isMaidToChest(baubleItem);
                    boolean isBlacklist = ItemWirelessIO.isBlacklist(baubleItem);
                    List<Boolean> slotConfig = ItemWirelessIO.getSlotConfig(baubleItem);
                    if (slotConfig != null) {
                        slotConfigData = new ArrayList<Boolean>(slotConfig);
                        slotConfigData.set(maidInv.getSlots() - 2, slotConfig.get(36));
                        slotConfigData.set(maidInv.getSlots() - 1, slotConfig.get(37));
                    } else {
                        slotConfigData = new ArrayList<Boolean>(Collections.nCopies(38, false));
                    }
                    ItemStackHandler filterList = ItemWirelessIO.getFilterList((class_7225.class_7874)maid.method_56673(), baubleItem);
                    if (isMaidToChest) {
                        this.maidToChest(maidInv, (Storage<ItemVariant>)chestInv, isBlacklist, filterList, slotConfigData);
                    } else {
                        this.chestToMaid((Storage<ItemVariant>)chestInv, maidInv, isBlacklist, filterList, slotConfigData);
                    }
                }
                if ((class_13092 = maid.method_35057()) instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)class_13092;
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "use_wireless_io");
                }
                return;
            }
        }
    }

    private void maidToChest(IItemHandler maid, Storage<ItemVariant> chest, boolean isBlacklist, IItemHandler filterList, List<Boolean> slotConfig) {
        for (int i = 0; i < maid.getSlots(); ++i) {
            class_1799 maidInvItem;
            if (i < slotConfig.size() && slotConfig.get(i).booleanValue() || (maidInvItem = maid.getStackInSlot(i)).method_7960()) continue;
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                class_1799 filterItem = filterList.getStackInSlot(j);
                boolean isEqual = class_1799.method_7984((class_1799)maidInvItem, (class_1799)filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove) continue;
            int beforeCount = maidInvItem.method_7947();
            try (Transaction transaction = Transaction.openOuter();){
                long inserted = chest.insert((Object)ItemVariant.of((class_1799)maidInvItem.method_7972()), (long)beforeCount, (TransactionContext)transaction);
                if (inserted <= 0L) continue;
                maid.extractItem(i, (int)inserted, false);
                transaction.commit();
                continue;
            }
        }
    }

    private void chestToMaid(Storage<ItemVariant> chest, IItemHandler maid, boolean isBlacklist, IItemHandler filterList, List<Boolean> slotConfig) {
        for (StorageView view : chest.nonEmptyViews()) {
            class_1799 after;
            int afterCount;
            int beforeCount;
            ItemVariant chestInvStack = (ItemVariant)view.getResource();
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                class_1799 filterItem = filterList.getStackInSlot(j);
                boolean isEqual = class_1799.method_7984((class_1799)chestInvStack.toStack(), (class_1799)filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove || (beforeCount = (int)view.getAmount()) == (afterCount = (after = WirelessIOBauble.insertItemStacked(maid, chestInvStack.toStack(beforeCount).method_7972(), false, slotConfig)).method_7947())) continue;
            Transaction transaction = Transaction.openOuter();
            try {
                chest.extract((Object)((ItemVariant)view.getResource()), (long)(beforeCount - afterCount), (TransactionContext)transaction);
                transaction.commit();
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
    }
}

