/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.stt.player2.response;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.player2.response.Message;
import com.google.gson.JsonSyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Consumer;

public class STTCallback
implements ResponseCallback<String> {
    private final Consumer<Message> consumer;

    public STTCallback(Consumer<Message> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void onFailure(HttpRequest request, Throwable e) {
        TouhouLittleMaid.LOGGER.error("Request failed: {}", (Object)request, (Object)e);
    }

    @Override
    public void onResponse(HttpResponse<String> response, Consumer<Throwable> failConsumer) {
        try {
            String string = response.body();
            if (this.isSuccessful(response)) {
                Message message = (Message)Service.GSON.fromJson(string, Message.class);
                this.consumer.accept(message);
            } else {
                TouhouLittleMaid.LOGGER.error("Request failed: {}", (Object)string);
                String message = String.format("HTTP Error Code: %d, Response %s", response.statusCode(), string);
                failConsumer.accept(new Throwable(message));
            }
        }
        catch (JsonSyntaxException e) {
            TouhouLittleMaid.LOGGER.error("JSON Syntax Exception: ", (Throwable)e);
            failConsumer.accept(e);
        }
    }
}

