/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import cn.sh1rocu.touhoulittlemaid.util.particle.ParticleUtil;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_727;

public class BlockStatue
extends class_2248
implements class_2343,
IBlock {
    public static final class_2746 IS_TINY = class_2746.method_11825((String)"is_tiny");

    @Override
    public boolean addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 manager) {
        if (target instanceof class_3965) {
            class_3965 blockTarget = (class_3965)target;
            if (world instanceof class_638) {
                class_638 clientWorld = (class_638)world;
                class_2338 pos = blockTarget.method_17777();
                this.crack(clientWorld, pos, class_2246.field_10460.method_9564(), blockTarget.method_17780());
            }
        }
        return true;
    }

    @Override
    public boolean addDestroyEffects(class_2680 state, class_1937 world, class_2338 pos, class_702 manager) {
        class_310.method_1551().field_1713.method_3046(pos, class_2246.field_10460.method_9564());
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private void crack(class_638 world, class_2338 pos, class_2680 state, class_2350 side) {
        if (state.method_26217() != class_2464.field_11455) {
            int posX = pos.method_10263();
            int posY = pos.method_10264();
            int posZ = pos.method_10260();
            class_238 aabb = state.method_26218((class_1922)world, pos).method_1107();
            double x = (double)posX + world.field_9229.method_43058() * (aabb.field_1320 - aabb.field_1323 - 0.2) + 0.1 + aabb.field_1323;
            double y = (double)posY + world.field_9229.method_43058() * (aabb.field_1325 - aabb.field_1322 - 0.2) + 0.1 + aabb.field_1322;
            double z = (double)posZ + world.field_9229.method_43058() * (aabb.field_1324 - aabb.field_1321 - 0.2) + 0.1 + aabb.field_1321;
            if (side == class_2350.field_11033) {
                y = (double)posY + aabb.field_1322 - 0.1;
            }
            if (side == class_2350.field_11036) {
                y = (double)posY + aabb.field_1325 + 0.1;
            }
            if (side == class_2350.field_11043) {
                z = (double)posZ + aabb.field_1321 - 0.1;
            }
            if (side == class_2350.field_11035) {
                z = (double)posZ + aabb.field_1324 + 0.1;
            }
            if (side == class_2350.field_11039) {
                x = (double)posX + aabb.field_1323 - 0.1;
            }
            if (side == class_2350.field_11034) {
                x = (double)posX + aabb.field_1320 + 0.1;
            }
            class_727 diggingParticle = new class_727(world, x, y, z, 0.0, 0.0, 0.0, state);
            class_310.method_1551().field_1713.method_3058(ParticleUtil.updateSprite(diggingParticle, state, pos).method_3075(0.2f).method_3087(0.6f));
        }
    }

    public BlockStatue() {
        super(class_4970.class_2251.method_9637().method_9626(class_2498.field_37640).method_9629(1.0f, 2.0f).method_22488());
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)IS_TINY, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
        if (!worldIn.field_9236) {
            this.getStatue((class_1922)worldIn, pos).ifPresent(statue -> {
                this.restoreClayBlock(worldIn, pos, (TileEntityStatue)statue);
                if (!player.method_7337()) {
                    class_2248.method_9577((class_1937)worldIn, (class_2338)pos, (class_1799)new class_1799((class_1935)class_2246.field_10460));
                }
            });
        }
        return super.method_9576(worldIn, pos, state, player);
    }

    @Override
    public void onBlockExploded(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion) {
        if (!world.field_9236) {
            this.getStatue((class_1922)world, pos).ifPresent(statue -> this.restoreClayBlock(world, pos, (TileEntityStatue)statue));
        }
        IBlock.super.onBlockExploded(state, world, pos, explosion);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{IS_TINY});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileEntityStatue(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    private Optional<TileEntityStatue> getStatue(class_1922 world, class_2338 pos) {
        class_2586 te = world.method_8321(pos);
        if (te instanceof TileEntityStatue) {
            return Optional.of((TileEntityStatue)te);
        }
        return Optional.empty();
    }

    private void restoreClayBlock(@Nonnull class_1937 worldIn, @Nonnull class_2338 pos, TileEntityStatue statue) {
        List<class_2338> posList = statue.getAllBlocks();
        for (class_2338 storagePos : posList) {
            if (storagePos.equals((Object)pos)) continue;
            this.getStatue((class_1922)worldIn, storagePos).ifPresent(s -> worldIn.method_8652(storagePos, class_2246.field_10460.method_9564(), 3));
        }
    }

    public boolean method_9542(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)IS_TINY);
    }

    public void method_9514(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        if (worldIn.method_8320(pos.method_10074()).method_27852(class_2246.field_10036)) {
            this.getStatue((class_1922)worldIn, pos).ifPresent(statue -> {
                worldIn.method_8501(pos, InitBlocks.GARAGE_KIT.method_9564());
                worldIn.method_20290(1009, pos, 0);
                class_2586 te = worldIn.method_8321(pos);
                if (te instanceof TileEntityGarageKit && statue.getExtraMaidData() != null) {
                    ((TileEntityGarageKit)te).setData(statue.getFacing(), statue.getExtraMaidData());
                }
            });
        }
    }
}

