/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail.MaidModelDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.AbstractModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidModelPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetMaidSoundIdPackage;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import org.apache.commons.lang3.StringUtils;

public class MaidModelGui
extends AbstractModelGui<EntityMaid, MaidModelInfo> {
    private static int PAGE_INDEX = 0;
    private static int PACK_INDEX = 0;
    private static int ROW_INDEX = 0;

    public MaidModelGui(EntityMaid maid) {
        super(maid, CustomPackLoader.MAID_MODELS.getPackList());
    }

    @Override
    protected void drawLeftEntity(class_332 graphics, int middleX, int middleY, float mouseX, float mouseY) {
        float renderItemScale = CustomPackLoader.MAID_MODELS.getModelRenderItemScale(((EntityMaid)this.entity).getModelId());
        int centerX = (middleX - 128) / 2;
        int yOffset = (int)(45.0f * (renderItemScale - 1.0f));
        class_490.method_2486((class_332)graphics, (int)(centerX - 100), (int)(middleY - 100), (int)(centerX + 100), (int)(middleY + 200 - yOffset), (int)((int)(45.0f * renderItemScale)), (float)0.1f, (float)mouseX, (float)mouseY, (class_1309)this.entity);
    }

    @Override
    protected void drawRightEntity(class_332 graphics, int posX, int posY, MaidModelInfo modelItem) {
        class_2960 cacheIconId = modelItem.getCacheIconId();
        Map allTextures = class_310.method_1551().method_1531().field_5286;
        if (((Boolean)MiscConfig.MODEL_ICON_CACHE.get()).booleanValue() && allTextures.containsKey(cacheIconId)) {
            int textureSize = 24;
            graphics.method_25293(cacheIconId, posX - textureSize / 2, posY - textureSize, textureSize, textureSize, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
        } else {
            this.drawEntity(graphics, posX, posY, modelItem);
        }
    }

    @Override
    protected void openDetailsGui(EntityMaid maid, MaidModelInfo modelInfo) {
        if (this.field_22787 != null && modelInfo.getEasterEgg() == null) {
            this.field_22787.method_1507((class_437)new MaidModelDetailsGui(maid, modelInfo));
        }
    }

    @Override
    protected void notifyModelChange(EntityMaid maid, MaidModelInfo info) {
        if (info.getEasterEgg() == null) {
            ClientPlayNetworking.send((class_8710)new MaidModelPackage(maid.method_5628(), info.getModelId()));
            String useSoundPackId = info.getUseSoundPackId();
            if (StringUtils.isNotBlank((CharSequence)useSoundPackId)) {
                ClientPlayNetworking.send((class_8710)new SetMaidSoundIdPackage(maid.method_5628(), useSoundPackId));
            }
            maid.handItemsForAnimation[0] = class_1799.field_8037;
            maid.handItemsForAnimation[1] = class_1799.field_8037;
        }
    }

    @Override
    protected void addModelCustomTips(MaidModelInfo modelItem, List<class_2561> tooltips) {
        String useSoundPackId = modelItem.getUseSoundPackId();
        if (StringUtils.isNotBlank((CharSequence)useSoundPackId)) {
            tooltips.add((class_2561)class_2561.method_43469((String)"gui.touhou_little_maid.skin.tooltips.maid_use_sound_pack_id", (Object[])new Object[]{useSoundPackId}).method_27692(class_124.field_1065));
        }
    }

    @Override
    protected int getPageIndex() {
        return PAGE_INDEX;
    }

    @Override
    protected void setPageIndex(int pageIndex) {
        PAGE_INDEX = pageIndex;
    }

    @Override
    protected int getPackIndex() {
        return PACK_INDEX;
    }

    @Override
    protected void setPackIndex(int packIndex) {
        PACK_INDEX = packIndex;
    }

    @Override
    protected int getRowIndex() {
        return ROW_INDEX;
    }

    @Override
    protected void setRowIndex(int rowIndex) {
        ROW_INDEX = rowIndex;
    }

    private void drawEntity(class_332 graphics, int posX, int posY, MaidModelInfo modelItem) {
        EntityMaid maid;
        class_638 world = Screens.getClient((class_437)this).field_1687;
        if (world == null) {
            return;
        }
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> MaidModelGui.lambda$drawEntity$1((class_1937)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (modelItem.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(modelItem.getModelId().toString());
        }
        maid.setIsYsmModel(false);
        class_490.method_2486((class_332)graphics, (int)(posX - 10), (int)(posY - 32), (int)(posX + 10), (int)(posY + 12), (int)((int)(12.0f * modelItem.getRenderItemScale())), (float)0.1f, (float)(posX + 25), (float)(posY + 5), (class_1309)maid);
    }

    private static /* synthetic */ class_1297 lambda$drawEntity$1(class_1937 world) throws Exception {
        class_1297 e = EntityMaid.TYPE.method_5883(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

