/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.input;

import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.player2.STTClient;
import com.github.tartaricacid.touhoulittlemaid.client.event.PressAIChatKeyEvent;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendUserChatPackage;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class STTChatKey {
    public static final class_304 STT_CHAT_KEY = new class_304("key.touhou_little_maid.stt_chat.desc", class_3675.class_307.field_1668, 88, "key.category.touhou_little_maid");
    private static final Timer TIMER = new Timer();

    public static void onSttChatPress(int key, int scanCode, int action, int mods) {
        if (STT_CHAT_KEY.method_1417(key, scanCode)) {
            if (!((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
                return;
            }
            class_746 player = class_310.method_1551().field_1724;
            if (player == null || player.method_7325()) {
                return;
            }
            if (!STTChatKey.isInGame()) {
                return;
            }
            if (action == 1) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)2.0f));
                STTChatKey.sttStart();
            }
            if (action == 0) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14627, (float)0.5f));
                class_1937 level = player.field_6002;
                class_238 aabb = player.method_5829().method_1014(12.0);
                final List maids = level.method_8390(EntityMaid.class, aabb, maid -> maid.method_6171((class_1309)player) && maid.method_5805() && PressAIChatKeyEvent.CAN_CHAT_MAID_IDS.contains(maid.getModelId()));
                maids.sort(Comparator.comparingDouble(maid -> maid.method_5858((class_1297)player)));
                if (maids.isEmpty()) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"ai.touhou_little_maid.stt.content.no_maid_found"));
                } else {
                    TIMER.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            STTChatKey.sttStop((EntityMaid)maids.get(0));
                        }
                    }, 1500L);
                }
            }
        }
    }

    private static boolean isInGame() {
        class_310 mc = class_310.method_1551();
        if (mc.method_18506() != null) {
            return false;
        }
        if (mc.field_1755 != null) {
            return false;
        }
        if (!mc.field_1729.method_1613()) {
            return false;
        }
        return mc.method_1569();
    }

    @Environment(value=EnvType.CLIENT)
    private static void sttStart() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
            String url = (String)AIConfig.STT_URL.get();
            if (StringUtils.isBlank((CharSequence)url)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"ai.touhou_little_maid.chat.stt.empty"));
            } else {
                STTClient sttClient = Service.getSttClient(url);
                sttClient.start(message -> {}, throwable -> {
                    String cause = throwable.getLocalizedMessage();
                    player.method_43496((class_2561)class_2561.method_43471((String)"ai.touhou_little_maid.stt.connect.fail").method_27693(cause).method_27692(class_124.field_1061));
                });
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void sttStop(EntityMaid maid) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (!((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
            return;
        }
        String url = (String)AIConfig.STT_URL.get();
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        STTClient sttClient = Service.getSttClient(url);
        sttClient.stop(message -> {
            String chatText = message.getText();
            if (StringUtils.isNotBlank((CharSequence)chatText)) {
                class_1076 languageManager = class_310.method_1551().method_1526();
                class_1077 info = languageManager.method_4668(languageManager.method_4669());
                String language = info != null ? info.method_48303().getString() : "English (US)";
                ClientPlayNetworking.send((class_8710)new SendUserChatPackage(maid.method_5628(), chatText, language));
                String name = player.method_5820();
                String format = String.format("<%s> %s", name, chatText);
                player.method_43496((class_2561)class_2561.method_43470((String)format).method_27692(class_124.field_1080));
            } else {
                player.method_43496((class_2561)class_2561.method_43471((String)"ai.touhou_little_maid.stt.content.empty").method_27692(class_124.field_1080));
            }
        }, throwable -> {
            String cause = throwable.getLocalizedMessage();
            player.method_43496((class_2561)class_2561.method_43471((String)"ai.touhou_little_maid.stt.connect.fail").method_27693(cause).method_27692(class_124.field_1061));
        });
    }
}

