/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidFollowOwnerTask
extends class_4097<EntityMaid> {
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18458));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected boolean checkExtraStartConditions(class_3218 level, EntityMaid maid) {
        return !maid.getSwimManager().isGoingToBreath();
    }

    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        class_1309 owner = maid.method_35057();
        int startDistance = (int)maid.method_18413() - 2;
        int minTeleportDistance = startDistance + 4;
        if (this.ownerStateConditions(owner) && this.maidStateConditions(maid) && !maid.method_24516((class_1297)owner, startDistance)) {
            if (!maid.method_24516((class_1297)owner, minTeleportDistance)) {
                maid.teleportToOwner(owner);
                maid.getNavigationManager().resetNavigation();
            } else if (!this.ownerIsWalkTarget(maid, owner)) {
                class_4215.method_24557((class_1309)maid, (class_1297)owner, (float)this.speedModifier, (int)this.stopDistance);
            }
        }
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    private boolean ownerStateConditions(@Nullable class_1309 owner) {
        return owner != null && !owner.method_7325() && !owner.method_29504();
    }

    private boolean ownerIsWalkTarget(EntityMaid maid, class_1309 owner) {
        return maid.method_18868().method_18904(class_4140.field_18445).map(target -> {
            if (target.method_19094() instanceof class_4102) {
                return ((class_4102)target.method_19094()).method_35066().equals((Object)owner);
            }
            return false;
        }).orElse(false);
    }
}

