/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChatBubbleInfo;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatTextType;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidChatBubbles;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.GetJarResources;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4168;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ChatBubbleManger {
    private static final Cache<Integer, ChatText> INNER_CHAT_TEXT_CACHE = CacheBuilder.newBuilder().expireAfterWrite(25L, TimeUnit.SECONDS).build();
    private static final String DEFAULT_CHAT_BUBBLE_PATH = String.format("/assets/%s/tlm_custom_pack/default_chat_bubble.json", "touhou_little_maid");
    private static final Random RANDOM = new Random();
    private static final String IDLE_CHAT_TEXT_ID = "idle";
    private static final String SLEEP_CHAT_TEXT_ID = "sleep";
    private static final String WORK_CHAT_TEXT_ID = "work";
    private static final String MORNING_CHAT_TEXT_ID = "morning";
    private static final String NIGHT_CHAT_TEXT_ID = "night";
    private static final String RAIN_CHAT_TEXT_ID = "rain";
    private static final String SNOW_CHAT_TEXT_ID = "snow";
    private static final String COLD_CHAT_TEXT_ID = "cold";
    private static final String HOT_CHAT_TEXT_ID = "hot";
    private static final String HURT_CHAT_TEXT_ID = "hurt";
    private static final String BEG_CHAT_TEXT_ID = "beg";
    private static final long MORNING_START = 0L;
    private static final long MORNING_END = 3000L;
    private static final long EVENING_START = 12000L;
    private static final long EVENING_END = 15000L;
    private static final float HIGH_TEMPERATURE = 0.95f;
    private static final long DURATION = 15000L;
    private static final int CHECK_RATE = 1200;
    public static ChatBubbleInfo DEFAULT_CHAT_BUBBLE = null;

    public static void addChatBubble(long endTime, ChatText text, EntityMaid maid) {
        if (System.currentTimeMillis() > endTime) {
            return;
        }
        if (text == ChatText.EMPTY_CHAT_TEXT) {
            return;
        }
        Pair bubbleItem = Pair.of((Object)endTime, (Object)text);
        MaidChatBubbles chatBubble = maid.getChatBubble();
        long minEndTime = -1L;
        int index = 1;
        Pair<Long, ChatText> bubble1 = chatBubble.bubble1();
        Pair<Long, ChatText> bubble2 = chatBubble.bubble2();
        Pair<Long, ChatText> bubble3 = chatBubble.bubble3();
        if ((Long)bubble1.getLeft() <= minEndTime) {
            minEndTime = (Long)bubble1.getLeft();
        }
        if ((Long)bubble2.getLeft() <= minEndTime) {
            minEndTime = (Long)bubble2.getLeft();
            index = 2;
        }
        if ((Long)bubble3.getLeft() <= minEndTime) {
            index = 3;
        }
        MaidChatBubbles newChatBubble = switch (index) {
            default -> new MaidChatBubbles((Pair<Long, ChatText>)bubbleItem, bubble2, bubble3);
            case 2 -> new MaidChatBubbles(bubble1, (Pair<Long, ChatText>)bubbleItem, bubble3);
            case 3 -> new MaidChatBubbles(bubble1, bubble2, (Pair<Long, ChatText>)bubbleItem);
        };
        maid.setChatBubble(newChatBubble);
    }

    public static int getChatBubbleCount(EntityMaid maid) {
        int count = 0;
        MaidChatBubbles chatBubble = maid.getChatBubble();
        Pair<Long, ChatText> bubble1 = chatBubble.bubble1();
        Pair<Long, ChatText> bubble2 = chatBubble.bubble2();
        Pair<Long, ChatText> bubble3 = chatBubble.bubble3();
        if (bubble1 != MaidChatBubbles.EMPTY) {
            ++count;
        }
        if (bubble2 != MaidChatBubbles.EMPTY) {
            ++count;
        }
        if (bubble3 != MaidChatBubbles.EMPTY) {
            ++count;
        }
        return count;
    }

    public static void tick(EntityMaid maid) {
        ChatBubbleManger.checkTimeoutChatBubble(maid);
        long offset1 = maid.method_5667().getLeastSignificantBits() % 1200L;
        long offset2 = maid.method_5667().getMostSignificantBits() % 1200L;
        if (((long)maid.field_6012 + offset1) % 1200L == 0L) {
            ChatBubbleManger.addMainChatText(maid);
        }
        if (((long)maid.field_6012 + offset2) % 1200L == 0L) {
            ChatBubbleManger.addSpecialChatText(maid);
        }
        if (((long)maid.field_6012 + offset1 + offset2) % 1200L == 0L) {
            ChatBubbleManger.addOtherChatText(maid);
        }
    }

    public static void initDefaultChat() {
        MaidDamageEvent.CALLBACK.register(ChatBubbleManger::addHurtChatText);
        InputStream stream = GetJarResources.readTouhouLittleMaidFile(DEFAULT_CHAT_BUBBLE_PATH);
        try {
            if (stream != null) {
                DEFAULT_CHAT_BUBBLE = (ChatBubbleInfo)ServerCustomPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), ChatBubbleInfo.class);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private static void checkTimeoutChatBubble(EntityMaid maid) {
        MaidChatBubbles chatBubble = maid.getChatBubble();
        Pair<Long, ChatText> bubble1 = chatBubble.bubble1();
        Pair<Long, ChatText> bubble2 = chatBubble.bubble2();
        Pair<Long, ChatText> bubble3 = chatBubble.bubble3();
        long currentTimeMillis = System.currentTimeMillis();
        if (bubble1 != MaidChatBubbles.EMPTY && currentTimeMillis > (Long)bubble1.getLeft()) {
            bubble1 = MaidChatBubbles.EMPTY;
        }
        if (bubble2 != MaidChatBubbles.EMPTY && currentTimeMillis > (Long)bubble2.getLeft()) {
            bubble2 = MaidChatBubbles.EMPTY;
        }
        if (bubble3 != MaidChatBubbles.EMPTY && currentTimeMillis > (Long)bubble3.getLeft()) {
            bubble3 = MaidChatBubbles.EMPTY;
        }
        maid.setChatBubble(new MaidChatBubbles(bubble1, bubble2, bubble3));
    }

    public static void addHurtChatText(MaidDamageEvent event) {
        ChatBubbleManger.addSpecialChatText(event.getMaid(), HURT_CHAT_TEXT_ID);
    }

    public static void addInnerChatText(EntityMaid maid, String key) {
        if (INNER_CHAT_TEXT_CACHE.getIfPresent((Object)maid.method_5628()) == null) {
            ChatText chatText = new ChatText(ChatTextType.TEXT, ChatText.EMPTY_ICON_PATH, String.format("{%s}", key));
            INNER_CHAT_TEXT_CACHE.put((Object)maid.method_5628(), (Object)chatText);
            maid.addChatBubble(ChatBubbleManger.getEndTime(), chatText);
        }
    }

    public static void addAiChatTextSync(EntityMaid maid, String message) {
        class_1937 class_19372;
        if (StringUtils.isNotBlank((CharSequence)message) && (class_19372 = maid.field_6002) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            MinecraftServer server = serverLevel.method_8503();
            server.method_20493(() -> ChatBubbleManger.addAiChatText(maid, message));
        }
    }

    public static void addAiChatText(EntityMaid maid, String message) {
        ChatText chatText = new ChatText(ChatTextType.TEXT, ChatText.EMPTY_ICON_PATH, message);
        maid.addChatBubble(ChatBubbleManger.getEndTime(), chatText);
        class_1309 class_13092 = maid.method_35057();
        if (class_13092 instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            class_2561 name = maid.method_5477();
            class_5250 msg = class_2561.method_43470((String)"<").method_10852(name).method_27693(">").method_10852(class_5244.field_41874).method_27693(message);
            player.method_43496((class_2561)msg.method_27692(class_124.field_1080));
        }
    }

    private static void addMainChatText(EntityMaid maid) {
        class_4168 activity = maid.getScheduleDetail();
        if (activity == class_4168.field_18595) {
            ChatBubbleManger.addMainChatText(maid, IDLE_CHAT_TEXT_ID);
            return;
        }
        if (activity == class_4168.field_18597) {
            ChatBubbleManger.addMainChatText(maid, SLEEP_CHAT_TEXT_ID);
            return;
        }
        if (activity == class_4168.field_18596) {
            ChatBubbleManger.addWorkChatText(maid, maid.getTask().getUid().method_12832());
        }
    }

    private static void addMainChatText(EntityMaid maid, String chatTextId) {
        List<ChatText> chatTexts = ChatBubbleManger.getChatTexts(maid, chatTextId, text -> text.getMain().get(chatTextId));
        ChatText randomChat = ChatBubbleManger.getRandomChatText(chatTexts);
        maid.addChatBubble(ChatBubbleManger.getEndTime(), randomChat);
    }

    private static void addWorkChatText(EntityMaid maid, String taskId) {
        List<ChatText> workChatTexts = ChatBubbleManger.getChatTexts(maid, WORK_CHAT_TEXT_ID, text -> text.getMain().get(WORK_CHAT_TEXT_ID));
        List<ChatText> taskChatTexts = ChatBubbleManger.getChatTexts(maid, taskId, text -> text.getMain().get(taskId));
        workChatTexts.addAll(taskChatTexts);
        ChatText randomChat = ChatBubbleManger.getRandomChatText(workChatTexts);
        maid.addChatBubble(ChatBubbleManger.getEndTime(), randomChat);
    }

    private static void addSpecialChatText(EntityMaid maid) {
        class_1937 world = maid.method_37908();
        class_2338 pos = maid.method_24515();
        long dayTime = world.method_8532();
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        if (maid.isBegging()) {
            ChatBubbleManger.addSpecialChatText(maid, BEG_CHAT_TEXT_ID);
            return;
        }
        if (0L < dayTime && dayTime < 3000L) {
            ChatBubbleManger.addSpecialChatText(maid, MORNING_CHAT_TEXT_ID);
            return;
        }
        if (12000L < dayTime && dayTime < 15000L) {
            ChatBubbleManger.addSpecialChatText(maid, NIGHT_CHAT_TEXT_ID);
            return;
        }
        if (world.method_8419() && SoundUtil.isRainBiome(biome, pos)) {
            ChatBubbleManger.addSpecialChatText(maid, RAIN_CHAT_TEXT_ID);
            return;
        }
        if (world.method_8419() && SoundUtil.isSnowyBiome(biome, pos)) {
            ChatBubbleManger.addSpecialChatText(maid, SNOW_CHAT_TEXT_ID);
            return;
        }
        if (biome.method_33599(pos)) {
            ChatBubbleManger.addSpecialChatText(maid, COLD_CHAT_TEXT_ID);
            return;
        }
        if (biome.method_21740(pos) > 0.95f) {
            ChatBubbleManger.addSpecialChatText(maid, HOT_CHAT_TEXT_ID);
        }
    }

    private static void addSpecialChatText(EntityMaid maid, String chatTextId) {
        List<ChatText> chatTexts = ChatBubbleManger.getChatTexts(maid, chatTextId, text -> text.getSpecial().get(chatTextId));
        ChatText randomChat = ChatBubbleManger.getRandomChatText(chatTexts);
        maid.addChatBubble(ChatBubbleManger.getEndTime(), randomChat);
    }

    private static void addOtherChatText(EntityMaid maid) {
        maid.getMaidBauble().fireEvent((b, s) -> {
            String chatBubbleId = b.getChatBubbleId();
            if (!chatBubbleId.isEmpty()) {
                List<ChatText> chatTexts = ChatBubbleManger.getChatTexts(maid, chatBubbleId, text -> text.getOther().get(chatBubbleId));
                maid.addChatBubble(ChatBubbleManger.getEndTime(), ChatBubbleManger.getRandomChatText(chatTexts));
                return true;
            }
            return false;
        });
    }

    private static ChatText getRandomChatText(List<ChatText> chatTexts) {
        int length = chatTexts.size();
        if (length == 0) {
            return ChatText.EMPTY_CHAT_TEXT;
        }
        int randomIndex = RANDOM.nextInt(length);
        return chatTexts.stream().skip(randomIndex).findFirst().orElse(ChatText.EMPTY_CHAT_TEXT);
    }

    private static List<ChatText> getChatTexts(EntityMaid maid, String chatTextId, Function<ChatBubbleInfo.Text, List<ChatText>> function) {
        ChatBubbleInfo chatBubble;
        List<ChatText> chatTextList;
        ArrayList result = Lists.newArrayList();
        Optional<MaidModelInfo> info = ServerCustomPackLoader.SERVER_MAID_MODELS.getInfo(maid.getModelId());
        if (info.isPresent() && (chatTextList = function.apply((chatBubble = info.get().getChatBubble()).getText())) != null && !chatTextList.isEmpty()) {
            result.addAll(chatTextList);
        }
        result.addAll(maid.getScriptBookManager().getScripts(chatTextId));
        return result;
    }

    private static long getEndTime() {
        return System.currentTimeMillis() + 15000L;
    }
}

