/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.message.CheckSchedulePosPacket;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4215;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record MaidConfigPackage(int id, boolean home, boolean pick, boolean ride, MaidSchedule schedule) implements class_8710
{
    public static final class_8710.class_9154<MaidConfigPackage> TYPE = new class_8710.class_9154(ResourceLocationUtil.getResourceLocation("maid_config"));
    public static final class_9139<ByteBuf, MaidConfigPackage> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_48550, MaidConfigPackage::id, (class_9139)class_9135.field_48547, MaidConfigPackage::home, (class_9139)class_9135.field_48547, MaidConfigPackage::pick, (class_9139)class_9135.field_48547, MaidConfigPackage::ride, MaidSchedule.STREAM_CODEC, MaidConfigPackage::schedule, MaidConfigPackage::new);

    public static void handle(MaidConfigPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            class_1297 entity = sender.field_6002.method_8469(message.id);
            if (entity instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)entity;
                if (((EntityMaid)entity).method_6171((class_1309)sender)) {
                    if (maid.isHomeModeEnable() != message.home) {
                        MaidConfigPackage.handleHome(message, sender, maid);
                    }
                    if (maid.isPickup() != message.pick) {
                        maid.setPickup(message.pick);
                    }
                    if (maid.isRideable() != message.ride) {
                        maid.setRideable(message.ride);
                    }
                    if (maid.method_5854() != null && !(maid.method_5854() instanceof EntitySit)) {
                        maid.method_5848();
                    }
                    if (maid.getSchedule() != message.schedule) {
                        class_1309 patt0$temp;
                        maid.setSchedule(message.schedule);
                        maid.getSchedulePos().restrictTo(maid);
                        if (maid.isHomeModeEnable()) {
                            class_4215.method_24561((class_1309)maid, (class_2338)maid.method_18412(), (float)0.7f, (int)3);
                        }
                        if ((patt0$temp = maid.method_35057()) instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)patt0$temp;
                            InitTrigger.MAID_EVENT.trigger(serverPlayer, "switch_schedule");
                        }
                    }
                }
            }
        });
    }

    private static void handleHome(MaidConfigPackage message, class_3222 sender, EntityMaid maid) {
        if (message.home) {
            class_2960 dimension = maid.getSchedulePos().getDimension();
            if (!dimension.equals((Object)maid.field_6002.method_27983().method_29177())) {
                CheckSchedulePosPacket tips = new CheckSchedulePosPacket("message.touhou_little_maid.check_schedule_pos.dimension");
                ServerPlayNetworking.send((class_3222)sender, (class_8710)tips);
                return;
            }
            class_2338 nearestPos = maid.getSchedulePos().getNearestPos(maid);
            if (nearestPos != null && nearestPos.method_10262((class_2382)maid.method_24515()) > 1024.0) {
                CheckSchedulePosPacket tips = new CheckSchedulePosPacket("message.touhou_little_maid.check_schedule_pos.too_far");
                ServerPlayNetworking.send((class_3222)sender, (class_8710)tips);
                return;
            }
            maid.getSchedulePos().setHomeModeEnable(maid, maid.method_24515());
        } else {
            maid.method_18408(class_2338.field_10980, (Integer)MaidConfig.MAID_NON_HOME_RANGE.get());
        }
        maid.setHomeModeEnable(message.home);
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

