package cn.sh1rocu.touhoulittlemaid.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import java.util.function.Consumer;

public class AddPackFindersEvent {
    private final class_3264 packType;
    private final Consumer<class_3285> sources;
    private final boolean trusted;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback c : callbacks)
            c.onAddPackFinders(event);
    });

    public interface Callback {
        void onAddPackFinders(AddPackFindersEvent event);
    }

    public AddPackFindersEvent(class_3264 packType, Consumer<class_3285> sources, boolean trusted) {
        this.packType = packType;
        this.sources = sources;
        this.trusted = trusted;
    }

    public void addRepositorySource(class_3285 source) {
        sources.accept(source);
    }

    public class_3264 getPackType() {
        return packType;
    }

    public boolean isTrusted() {
        return trusted;
    }
}