package com.github.tartaricacid.touhoulittlemaid.ai.service.tts;

import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.SystemServices;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Nullable;

public interface TTSSystemServices extends SystemServices {
    void play(String message, TTSConfig config, @Nullable ResponseCallback<byte[]> callback);

    default boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    default void writeToNetwork(String message, TTSConfig config, class_2540 buffer) {
        buffer.method_10814(message);
        buffer.method_10814(config.model());
        buffer.method_10814(config.language());
    }

    default Pair<String, TTSConfig> readFromNetwork(class_2540 buffer) {
        String message = buffer.method_19772();
        String model = buffer.method_19772();
        String language = buffer.method_19772();
        return Pair.of(message, new TTSConfig(model, language));
    }
}