package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_863;
import javax.annotation.Nullable;
import java.util.concurrent.TimeUnit;

@Environment(EnvType.CLIENT)
public class MaidAreaRenderEvent {
    private static final Cache<Integer, SchedulePos> CACHE = CacheBuilder.newBuilder().expireAfterWrite(30, TimeUnit.SECONDS).build();

    //after block entities
    public static void onRender(WorldRenderContext context) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return;
        }
        class_243 camera = context.camera().method_19326().method_22882();
        class_4587 poseStack = context.matrixStack();
        for (int id : CACHE.asMap().keySet()) {
            SchedulePos pos = CACHE.getIfPresent(id);
            if (pos == null) {
                continue;
            }
            class_1297 entity = mc.field_1687.method_8469(id);
            if (!(entity instanceof EntityMaid maid)) {
                return;
            }
            class_2960 dimension = pos.getDimension();
            if (mc.field_1724.field_6002.method_27983().method_29177().equals(dimension)) {
                renderPos(pos.getWorkPos(), pos.getIdlePos(), pos.getSleepPos(), camera, poseStack, mc, maid, mc.field_1724);
            }
        }
    }

    private static void renderPos(@Nullable class_2338 workPos, @Nullable class_2338 idlePos, @Nullable class_2338 resetPos, class_243 camera, class_4587 poseStack, class_310 mc, EntityMaid maid, class_1657 player) {
        poseStack.method_22903();
        poseStack.method_46416(0, 1, 0);

        class_2338 restrictCenter = maid.method_18412();
        class_243 restrictPos = camera.method_1031(restrictCenter.method_10263() + 0.5, restrictCenter.method_10264() + 0.5, restrictCenter.method_10260() + 0.5);
        if (!maid.isHomeModeEnable()) {
            restrictPos = camera.method_1019(player.method_19538());
        }
        class_243 maidPos = camera.method_1019(maid.method_19538());
        RenderHelper.renderLine(poseStack, mc.method_22940().method_23000().getBuffer(class_1921.field_21695), restrictPos, maidPos, 1.0f, 0.2f, 0.2f);
        class_238 aabb = maid.method_5829().method_989(0, -1, 0).method_997(camera);
        class_863.method_23102(poseStack, mc.method_22940().method_23000(), aabb, 0.8F, 0.8F, 0.2F, 0.75F);

        if (workPos != null) {
            class_243 centerPos = camera.method_1031(workPos.method_10263() + 0.5, workPos.method_10264() + 0.5, workPos.method_10260() + 0.5);
            double radius = MaidConfig.MAID_WORK_RANGE.get() + 0.1;
            class_4588 buffer = mc.method_22940().method_23000().getBuffer(class_1921.field_21695);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 1.0F, 0, 0);

            class_243 textPos = new class_243(workPos.method_10263() + 0.5, workPos.method_10264() + 2, workPos.method_10260() + 0.5);
            String text = class_1074.method_4662("message.touhou_little_maid.kappa_compass.work_area");
            RenderHelper.renderFloatingText(poseStack, text, textPos.field_1352, textPos.field_1351, textPos.field_1350, 0xff1111, 0.15f, true, -5, false);
            RenderHelper.renderFloatingText(poseStack, "▼", textPos.field_1352, textPos.field_1351, textPos.field_1350, 0xff1111, 0.15f, true, 5, false);
        }

        if (idlePos != null) {
            class_243 centerPos = camera.method_1031(idlePos.method_10263() + 0.5, idlePos.method_10264() + 0.5, idlePos.method_10260() + 0.5);
            double radius = MaidConfig.MAID_IDLE_RANGE.get();
            class_4588 buffer = mc.method_22940().method_23000().getBuffer(class_1921.field_21695);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0, 1.0F, 0);
            class_243 textPos = new class_243(idlePos.method_10263() + 0.5, idlePos.method_10264() + 2, idlePos.method_10260() + 0.5);
            if (idlePos.equals(workPos)) {
                textPos = textPos.method_1031(0, 1, 0);
            } else if (workPos != null) {
                class_243 prePos = camera.method_1031(workPos.method_10263() + 0.5, workPos.method_10264() + 0.5, workPos.method_10260() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            String text = class_1074.method_4662("message.touhou_little_maid.kappa_compass.idle_area");
            RenderHelper.renderFloatingText(poseStack, text, textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x11ff11, 0.15f, true, -5, false);
            RenderHelper.renderFloatingText(poseStack, "▼", textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x11ff11, 0.15f, true, 5, false);
        }

        if (resetPos != null) {
            class_243 centerPos = camera.method_1031(resetPos.method_10263() + 0.5, resetPos.method_10264() + 0.5, resetPos.method_10260() + 0.5);
            double radius = MaidConfig.MAID_SLEEP_RANGE.get() - 0.1;
            class_4588 buffer = mc.method_22940().method_23000().getBuffer(class_1921.field_21695);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0, 0, 1.0F);
            class_243 textPos = new class_243(resetPos.method_10263() + 0.5, resetPos.method_10264() + 2, resetPos.method_10260() + 0.5);
            if (resetPos.equals(idlePos)) {
                textPos = textPos.method_1031(0, 2, 0);
            } else if (idlePos != null && workPos != null) {
                class_243 prePos = camera.method_1031(idlePos.method_10263() + 0.5, idlePos.method_10264() + 0.5, idlePos.method_10260() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                prePos = camera.method_1031(workPos.method_10263() + 0.5, workPos.method_10264() + 0.5, workPos.method_10260() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            String text = class_1074.method_4662("message.touhou_little_maid.kappa_compass.sleep_area");
            RenderHelper.renderFloatingText(poseStack, text, textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x1111ff, 0.15f, true, -5, false);
            RenderHelper.renderFloatingText(poseStack, "▼", textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x1111ff, 0.15f, true, 5, false);
        }

        poseStack.method_22909();
    }

    public static void addSchedulePos(int id, SchedulePos pos) {
        CACHE.put(id, pos);
    }
}
