package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.WChessPiecesModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityWChess;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class TileEntityWChessRenderer implements class_827<TileEntityWChess> {
    private static final class_2960 TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/block/wchess.png");
    private static final class_2960 PIECES_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/block/wchess_pieces.png");
    private static final int TIPS_RENDER_DISTANCE = 16;
    private static final int PIECE_RENDER_DISTANCE = 24;
    private final class_327 font;
    private final class_824 dispatcher;
    private final SimpleBedrockModel<class_1297> chessModel;
    private final WChessPiecesModel[] chessPiecesModels;
    private final WChessPiecesModel selectedModels;

    public TileEntityWChessRenderer(class_5614.class_5615 context) {
        chessModel = BedrockModelLoader.getModel(BedrockModelLoader.WCHESS);
        chessPiecesModels = WChessPiecesModel.initModel();
        selectedModels = WChessPiecesModel.getSelectedModel();
        dispatcher = context.method_32139();
        font = context.method_32143();
    }

    @Override
    public void render(TileEntityWChess cchess, float pPartialTick, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_2350 facing = cchess.method_11010().method_11654(BlockGomoku.FACING);
        this.renderChessboard(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, facing);
        this.renderPiece(cchess, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, facing);
        this.renderTipsText(cchess, poseStack, bufferIn, combinedLightIn);
    }

    private void renderTipsText(TileEntityWChess chess, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn) {
        boolean showTips = chess.isCheckmate() || chess.isRepeat() || chess.isMoveNumberLimit();
        if (!showTips || !inRenderDistance(chess, TIPS_RENDER_DISTANCE)) {
            return;
        }

        class_4184 camera = this.dispatcher.field_4344;
        class_5250 loseTips = null;
        class_5250 resetTips = class_2561.method_43471("message.touhou_little_maid.wchess.reset").method_27692(class_124.field_1073).method_27692(class_124.field_1075);
        class_5250 roundText = class_2561.method_43469("message.touhou_little_maid.gomoku.round", chess.getChessCounter()).method_27692(class_124.field_1068);
        class_5250 preRoundIcon = class_2561.method_43470("⏹ ").method_27692(class_124.field_1060);
        class_5250 postRoundIcon = class_2561.method_43470(" ⏹").method_27692(class_124.field_1060);
        class_5250 roundTips = preRoundIcon.method_10852(roundText).method_10852(postRoundIcon);

        if (chess.isCheckmate()) {
            if (!chess.isPlayerTurn()) {
                loseTips = class_2561.method_43471("message.touhou_little_maid.gomoku.win").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
            } else {
                loseTips = class_2561.method_43471("message.touhou_little_maid.gomoku.lose").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
            }
        } else if (chess.isMoveNumberLimit()) {
            loseTips = class_2561.method_43471("message.touhou_little_maid.cchess.move_limit").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
        } else if (chess.isRepeat()) {
            loseTips = class_2561.method_43471("message.touhou_little_maid.cchess.repeat").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
        }
        if (loseTips == null) {
            return;
        }

        float loseTipsWidth = (float) (-this.font.method_27525(loseTips) / 2);
        float resetTipsWidth = (float) (-this.font.method_27525(resetTips) / 2);
        float roundTipsWidth = (float) (-this.font.method_27525(roundTips) / 2);
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.75, 0.5);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(180 + camera.method_19330()));
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(camera.method_19329()));
        poseStack.method_22905(0.03F, -0.03F, 0.03F);
        this.font.method_30882(loseTips, loseTipsWidth, -10, 0xFFFFFF, true, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
        poseStack.method_22905(0.5F, 0.5F, 0.5F);
        this.font.method_30882(roundTips, roundTipsWidth, -30, 0xFFFFFF, true, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
        this.font.method_30882(resetTips, resetTipsWidth, 0, 0xFFFFFF, true, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
        poseStack.method_22909();
    }

    private void renderPiece(TileEntityWChess cchess, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, class_2350 facing) {
        if (inRenderDistance(cchess, PIECE_RENDER_DISTANCE)) {
            class_4588 piecesBuff = bufferIn.getBuffer(class_1921.method_23578(PIECES_TEXTURE));
            int selectX = Position.FILE_X(cchess.getSelectChessPoint());
            int selectY = Position.RANK_Y(cchess.getSelectChessPoint());
            byte[] data = cchess.getChessData().squares;
            poseStack.method_22903();
            switch (facing) {
                case field_11043:
                    poseStack.method_22904(0.875 + 0.5, 1.625, 0.875 + 0.5);
                    break;
                case field_11034:
                    poseStack.method_22904(-0.875 + 0.5, 1.625, 0.875 + 0.5);
                    break;
                case field_11039:
                    poseStack.method_22904(0.875 + 0.5, 1.625, -0.875 + 0.5);
                    break;
                default:
                    poseStack.method_22904(-0.875 + 0.5, 1.625, -0.875 + 0.5);
                    break;
            }
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(facing.method_10161() * 90));
            if (facing == class_2350.field_11035 || facing == class_2350.field_11043) {
                poseStack.method_22907(class_7833.field_40715.rotationDegrees(180));
            }
            for (int y = Position.RANK_TOP; y <= Position.RANK_BOTTOM; y++) {
                for (int x = Position.FILE_LEFT; x <= Position.FILE_RIGHT; x++) {
                    byte piecesIndex = data[Position.COORD_XY(x, y)];
                    if (WChessUtil.isWhite(piecesIndex) || WChessUtil.isBlack(piecesIndex)) {
                        WChessPiecesModel chessPiecesModel = this.chessPiecesModels[piecesIndex];
                        chessPiecesModel.renderToBuffer(poseStack, piecesBuff, combinedLightIn, combinedOverlayIn, 1.0F, 1.0F, 1.0F, 1.0F);
                        if (selectX == x && selectY == y) {
                            selectedModels.renderToBuffer(poseStack, piecesBuff, combinedLightIn, combinedOverlayIn, 1.0F, 1.0F, 1.0F, 1.0F);
                        }
                    }
                    poseStack.method_22904(0.25, 0, 0);
                }
                poseStack.method_22904(-0.25 * 8, 0, -0.25);
            }
            poseStack.method_22909();
        }
    }

    private void renderChessboard(class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, class_2350 facing) {
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.5, 0.5);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(facing.method_10161() * 90));
        if (facing == class_2350.field_11035 || facing == class_2350.field_11043) {
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(180));
        }
        class_4588 checkerBoardBuff = bufferIn.getBuffer(class_1921.method_23578(TEXTURE));
        chessModel.method_60879(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn);
        poseStack.method_22909();
    }

    private boolean inRenderDistance(TileEntityWChess chess, int distance) {
        class_2338 pos = chess.method_11016();
        return this.dispatcher.field_4344.method_19326().method_1028(pos.method_10263(), pos.method_10264(), pos.method_10260()) < distance * distance;
    }

    @Override
    public boolean shouldRenderOffScreen(TileEntityWChess te) {
        return true;
    }
}