package com.github.tartaricacid.touhoulittlemaid.client.resource;

import com.github.tartaricacid.simplebedrockmodel.client.manager.BedrockEntityModelRegister;
import com.github.tartaricacid.simplebedrockmodel.client.manager.BedrockEntityModelRegisterEvent;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.BroomModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityBoxModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityFairyModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.NewEntityFairyModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.google.common.collect.Maps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import javax.annotation.Nullable;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;

/**
 * 把所有硬编码的模型全部资源包化，方便资源包替换模型
 */
@Environment(EnvType.CLIENT)
public class BedrockModelLoader {
    // 内部数据
    private static final Map<class_2960, Function<InputStream, ? extends SimpleBedrockModel<? extends class_1297>>> ALL_MODELS = Maps.newHashMap();

    // 注册数据
    public static final class_2960 ALTAR = registerSimpleBlockModel("altar");
    public static final class_2960 BOOKSHELF = registerSimpleBlockModel("bookshelf");
    public static final class_2960 COMPUTER = registerSimpleBlockModel("computer");
    public static final class_2960 KEYBOARD = registerSimpleBlockModel("keyboard");
    public static final class_2960 PICNIC_MAT = registerSimpleBlockModel("picnic_mat");
    public static final class_2960 PICNIC_BASKET = registerSimpleBlockModel("picnic_basket");
    public static final class_2960 STATUE_BASE = registerSimpleBlockModel("statue_base");
    public static final class_2960 SHRINE = registerSimpleBlockModel("shrine");
    public static final class_2960 GOMOKU = registerSimpleBlockModel("gomoku");
    public static final class_2960 GOMOKU_PIECE = registerSimpleBlockModel("gomoku_piece");
    public static final class_2960 CCHESS = registerSimpleBlockModel("cchess");
    public static final class_2960 CCHESS_PIECES = registerSimpleBlockModel("cchess_pieces");
    public static final class_2960 WCHESS = registerSimpleBlockModel("wchess");
    public static final class_2960 WCHESS_PIECES = registerSimpleBlockModel("wchess_pieces");

    public static final class_2960 CAKE_BOX = registerEntityModel("cake_box", EntityBoxModel::new);
    public static final class_2960 MAID_FAIRY = registerEntityModel("maid_fairy", EntityFairyModel::new);
    public static final class_2960 NEW_MAID_FAIRY = registerEntityModel("new_maid_fairy", NewEntityFairyModel::new);
    public static final class_2960 BROOM = registerEntityModel("broom", BroomModel::new);

    public static final class_2960 REIMU_YUKKURI = registerSimpleEntityModel("reimu_yukkuri");
    public static final class_2960 MARISA_YUKKURI = registerSimpleEntityModel("marisa_yukkuri");
    public static final class_2960 TOMBSTONE = registerSimpleEntityModel("tombstone");
    public static final class_2960 MAID_BANNER = registerSimpleEntityModel("maid_banner");

    public static final class_2960 BIG_BACKPACK = registerSimpleEntityModel("backpack/big_backpack");
    public static final class_2960 CRAFTING_TABLE_BACKPACK = registerSimpleEntityModel("backpack/crafting_table_backpack");
    public static final class_2960 END_CHEST_BACKPACK = registerSimpleEntityModel("backpack/end_chest_backpack");
    public static final class_2960 FURNACE_BACKPACK = registerSimpleEntityModel("backpack/furnace_backpack");
    public static final class_2960 MIDDLE_BACKPACK = registerSimpleEntityModel("backpack/middle_backpack");
    public static final class_2960 SMALL_BACKPACK = registerSimpleEntityModel("backpack/small_backpack");
    public static final class_2960 TANK_BACKPACK = registerSimpleEntityModel("backpack/tank_backpack");

    public static class_2960 registerSimpleBlockModel(String name) {
        class_2960 location = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "bedrock/block/" + name);
        return registerSimpleModel(location);
    }

    public static class_2960 registerSimpleEntityModel(String name) {
        class_2960 location = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "bedrock/entity/" + name);
        return registerSimpleModel(location);
    }

    public static class_2960 registerSimpleModel(class_2960 location) {
        return registerModel(location, SimpleBedrockModel::new);
    }

    public static class_2960 registerBlockModel(String name, Function<InputStream, ? extends SimpleBedrockModel<? extends class_1297>> function) {
        class_2960 location = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "bedrock/block/" + name);
        return registerModel(location, function);
    }

    public static class_2960 registerEntityModel(String name, Function<InputStream, ? extends SimpleBedrockModel<? extends class_1297>> function) {
        class_2960 location = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "bedrock/entity/" + name);
        return registerModel(location, function);
    }

    public static class_2960 registerModel(class_2960 location, Function<InputStream, ? extends SimpleBedrockModel<? extends class_1297>> function) {
        ALL_MODELS.put(location, function);
        return location;
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    public static void onRegisterBedrockModelRenderers(BedrockEntityModelRegisterEvent event) {
        ALL_MODELS.forEach(event::register);
        ALL_MODELS.clear();
    }

    @SuppressWarnings("unchecked")
    @Nullable
    public static <T extends class_1297> SimpleBedrockModel<T> getModel(class_2960 location) {
        return (SimpleBedrockModel<T>) BedrockEntityModelRegister.INSTANCE.getModel(location);
    }
}