package com.github.tartaricacid.touhoulittlemaid.compat.jade.provider;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.AddJadeInfoEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4168;
import net.minecraft.class_5250;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum MaidProvider implements IEntityComponentProvider {

    INSTANCE;

    private static final class_2960 UID = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "maid");

    @Override
    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        if (entityAccessor.getEntity() instanceof EntityMaid maid) {
            if (maid.method_6181()) {
                IMaidTask task = maid.getTask();
                iTooltip.add(class_2561.method_43471("top.touhou_little_maid.entity_maid.task").method_10852(task.getName()));

                // 添加于 Mode 之下，用于给 Mode 添加额外的信息
                AddJadeInfoEvent.CALLBACK.invoker().post(new AddJadeInfoEvent(maid, iTooltip, iPluginConfig));

                iTooltip.add(class_2561.method_43471("top.touhou_little_maid.entity_maid.schedule").method_10852(getActivityTransText(maid)));
                iTooltip.add(class_2561.method_43469("top.touhou_little_maid.entity_maid.favorability", maid.getFavorabilityManager().getLevel()));
                iTooltip.add(class_2561.method_43469("top.touhou_little_maid.entity_maid.nex_favorability_point", maid.getFavorabilityManager().nextLevelPoint()));
                if (maid.getIsInvulnerable()) {
                    iTooltip.add(class_2561.method_43471("top.touhou_little_maid.entity_maid.invulnerable").method_27692(class_124.field_1064));
                }
            }
        }
    }

    @Override
    public class_2960 getUid() {
        return UID;
    }

    private class_5250 getActivityTransText(EntityMaid maid) {
        return getActivityTransText(maid.getScheduleDetail());
    }

    private class_5250 getActivityTransText(class_4168 activity) {
        return class_2561.method_43471("gui.touhou_little_maid.activity." + activity.method_19634());
    }
}
