package com.github.tartaricacid.touhoulittlemaid.datagen.tag;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.CompletableFuture;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public class TagItem extends FabricTagProvider<class_1792> {
    public static final class_6862<class_1792> GOHEI_ENCHANTABLE = class_6862.method_40092(class_7924.field_41197, getResourceLocation("gohei_enchantable"));
    public static final class_6862<class_1792> MAID_PLANTABLE_SEEDS = class_6862.method_40092(class_7924.field_41197, getResourceLocation("maid_plantable_seeds"));
    public static final class_6862<class_1792> MAID_TAMED_ITEM = class_6862.method_40092(class_7924.field_41197, getResourceLocation("maid_tamed_item"));
    public static final class_6862<class_1792> MAID_MENDING_BLOCKLIST_ITEM = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655(TouhouLittleMaid.MOD_ID, "maid_mending_blocklist_item"));
    public static final class_6862<class_1792> MAID_VANISHING_BLOCKLIST_ITEM = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655(TouhouLittleMaid.MOD_ID, "maid_vanishing_blocklist_item"));

    public TagItem(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(output, class_7924.field_41197, completableFuture);
    }


    @Override
    protected void method_10514(class_7225.@NotNull class_7874 pProvider) {
        getOrCreateTagBuilder(GOHEI_ENCHANTABLE).add(InitItems.HAKUREI_GOHEI);
        getOrCreateTagBuilder(GOHEI_ENCHANTABLE).add(InitItems.SANAE_GOHEI);

        getOrCreateTagBuilder(class_3489.field_48310).add(InitItems.HAKUREI_GOHEI)
                .add(InitItems.SANAE_GOHEI)
                .add(InitItems.ULTRAMARINE_ORB_ELIXIR)
                .add(InitItems.EXPLOSION_PROTECT_BAUBLE)
                .add(InitItems.FIRE_PROTECT_BAUBLE)
                .add(InitItems.PROJECTILE_PROTECT_BAUBLE)
                .add(InitItems.MAGIC_PROTECT_BAUBLE)
                .add(InitItems.FALL_PROTECT_BAUBLE)
                .add(InitItems.DROWN_PROTECT_BAUBLE)
                .add(InitItems.NIMBLE_FABRIC);

        getOrCreateTagBuilder(MAID_PLANTABLE_SEEDS).forceAddTag(class_3489.field_44591);
        getOrCreateTagBuilder(MAID_PLANTABLE_SEEDS).add(class_1802.field_8790);

        getOrCreateTagBuilder(MAID_TAMED_ITEM)
                .add(class_1802.field_17534)
                .method_35923(class_2960.method_60654("forge:cakes"))
                .method_35923(class_2960.method_60654("c:cakes"))
                .method_35923(class_2960.method_60654("jmc:cakes"))
                .method_35922(class_2960.method_60654("kawaiidishes:cheese_cake"))
                .method_35922(class_2960.method_60654("kawaiidishes:honey_cheese_cake"))
                .method_35922(class_2960.method_60654("kawaiidishes:chocolate_cheese_cake"))
                .method_35922(class_2960.method_60654("kawaiidishes:piece_of_cake"))
                .method_35922(class_2960.method_60654("kawaiidishes:piece_of_cheesecake"))
                .method_35922(class_2960.method_60654("kawaiidishes:piece_of_chocolate_cheesecake"))
                .method_35922(class_2960.method_60654("kawaiidishes:piece_of_honey_cheesecake"));

        getOrCreateTagBuilder(MAID_MENDING_BLOCKLIST_ITEM).add(InitItems.ULTRAMARINE_ORB_ELIXIR);
        getOrCreateTagBuilder(MAID_VANISHING_BLOCKLIST_ITEM).add(InitItems.ULTRAMARINE_ORB_ELIXIR);
    }
}
