package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.block.IMultiBlock;
import com.github.tartaricacid.touhoulittlemaid.block.multiblock.MultiBlockManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import java.util.List;
import java.util.function.Predicate;

public class ItemHakureiGohei extends class_1811 {
    public ItemHakureiGohei() {
        super((new class_1793())
                .method_7895(300)
                /*.setNoRepair()*/
                .method_57348(class_9285.method_57480()
                        .method_57487(class_5134.field_23721, new class_1322(field_8006, 4, class_1322.class_1323.field_6328), class_9274.field_49217)
                        .method_57487(class_5134.field_23723, new class_1322(field_8001, -2, class_1322.class_1323.field_6328), class_9274.field_49217)
                        .method_57486()));
    }

    public static boolean isGohei(class_1799 stack) {
        return stack.method_7909() instanceof ItemHakureiGohei;
    }

    @Override
    public Predicate<class_1799> method_19268() {
        return Predicates.alwaysTrue();
    }

    @Override
    public int method_24792() {
        return 15;
    }

    @Override
    protected void method_7763(class_1309 pShooter, class_1676 pProjectile, int pIndex, float pVelocity, float pInaccuracy, float pAngle, @Nullable class_1309 pTarget) {
        // 御币不能发射弹幕的，所以该方法为空体
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 pEntity) {
        return 500;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_20287() == class_1268.field_5808) {
            List<IMultiBlock> multiBlockList = MultiBlockManager.getMultiBlockList();
            class_2680 blockState = context.method_8045().method_8320(context.method_8037());
            class_1937 world = context.method_8045();
            class_2338 pos = context.method_8037();
            class_2350 direction = context.method_8038();

            for (IMultiBlock multiBlock : multiBlockList) {
                if (multiBlock.isCoreBlock(blockState) && multiBlock.directionIsSuitable(direction)) {
                    if (world instanceof class_3218 serverLevel) {
                        class_2338 posStart = pos.method_10081(multiBlock.getCenterPos(direction));
                        class_3499 template = multiBlock.getTemplate(serverLevel, direction);
                        if (multiBlock.isMatch(world, posStart, direction, template)) {
                            multiBlock.build(world, posStart, direction, template);
                            serverLevel.method_8396(null, pos, class_3417.field_14703, class_3419.field_15245, 1.5f, 1);
                            if (context.method_8036() instanceof class_3222 serverPlayer) {
                                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.BUILD_ALTAR);
                            }
                        }
                    }
                    return class_1269.field_5812;
                }
            }
        }
        return super.method_7884(context);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7970(2, attacker, attacker.method_32326(stack));
        return true;
    }

    @Override
    public boolean method_7870(class_1799 pStack) {
        return super.method_7870(pStack);
    }
}
