package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.util.PlaceHelper;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import java.util.List;

public class ItemPhoto extends AbstractStoreMaidItem {
    public ItemPhoto() {
        super((new class_1793()).method_7889(1));
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_2350 clickedFace = context.method_8038();
        class_1657 player = context.method_8036();
        class_1937 worldIn = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        if (player == null) {
            return super.method_7884(context);
        }
        if (clickedFace == class_2350.field_11036 && !PlaceHelper.notSuitableForPlaceMaid(worldIn, clickedPos)) {
            EntityMaid maid = InitEntities.MAID.method_5883(worldIn);
            if (maid == null) {
                return super.method_7884(context);
            }
            return spawnFromStore(context, player, worldIn, maid, () -> {
                context.method_8041().method_7934(1);
            });
        } else {
            if (context.method_8041().method_57824(InitDataComponent.MAID_INFO) != null && worldIn.field_9236) {
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.photo.not_suitable_for_place_maid"));
            }
        }
        return super.method_7884(context);
    }

    @Override
    public boolean method_31568() {
        return false;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1792.class_9635 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (stack.method_57824(InitDataComponent.MAID_INFO) == null) {
            tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.photo.no_data.desc").method_27692(class_124.field_1079));
        }
    }
}
