package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3499;
import net.minecraft.class_5425;

@Mixin(class_3499.class)
public abstract class StructureTemplateMixin {
    @Unique
    private static final Random TOUHOU_LITTLE_MAID$RANDOM = new Random();

    @Inject(method = "createEntityIgnoreException(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/nbt/CompoundTag;)Ljava/util/Optional;", at = @At("RETURN"), cancellable = true)
    private static void createEntityIgnoreException(class_5425 accessor, class_2487 tag, CallbackInfoReturnable<Optional<class_1297>> ci) {
        ci.getReturnValue().ifPresent(entity -> {
            class_3218 level = accessor.method_8410();
            if (entity.method_5864().equals(class_1299.field_38384) && TOUHOU_LITTLE_MAID$RANDOM.nextDouble() < MaidConfig.REPLACE_ALLAY_PERCENT.get()) {
                EntityMaid entityMaid = InitEntities.MAID.method_5883(level);
                ci.setReturnValue(Optional.ofNullable(entityMaid));
            }
        });
    }
}
