/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.DefaultMaidTaskConfigContainer;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_7893;

public interface IMaidTask {
    public static final int VERTICAL_SEARCH_RANGE = 4;

    public class_2960 getUid();

    public class_1799 getIcon();

    @Nullable
    public class_3414 getAmbientSound(EntityMaid var1);

    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid var1);

    default public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        return Collections.emptyList();
    }

    default public boolean isEnable(EntityMaid maid) {
        return true;
    }

    default public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return true;
    }

    default public boolean enablePanic(EntityMaid maid) {
        return true;
    }

    default public boolean enableEating(EntityMaid maid) {
        return true;
    }

    default public boolean workPointTask(EntityMaid maid) {
        return false;
    }

    default public boolean canSitInJoy(EntityMaid maid, String joyType) {
        return false;
    }

    default public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return Collections.emptyList();
    }

    default public class_5250 getName() {
        return class_2561.method_43471((String)String.format("task.%s.%s", this.getUid().method_12836(), this.getUid().method_12832()));
    }

    default public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.emptyList();
    }

    default public List<String> getDescription(EntityMaid maid) {
        String key = String.format("task.%s.%s.desc", this.getUid().method_12836(), this.getUid().method_12832());
        return Lists.newArrayList((Object[])new String[]{key});
    }

    default public class_3908 getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.method_5628();
        return new ExtendedScreenHandlerFactory<Integer>(){

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Maid Task Config Container");
            }

            public AbstractMaidContainer createMenu(int index, class_1661 playerInventory, class_1657 player) {
                return new DefaultMaidTaskConfigContainer(index, playerInventory, entityId);
            }

            public Integer getScreenOpeningData(class_3222 player) {
                return entityId;
            }

            public boolean shouldCloseCurrentScreen() {
                return false;
            }
        };
    }

    default public class_3908 getTaskInfoGuiProvider(EntityMaid maid) {
        return maid.getMaidBackpackType().getGuiProvider(maid.method_5628());
    }

    default public class_238 searchDimension(EntityMaid maid) {
        float radius = this.searchRadius(maid);
        if (maid.method_18410()) {
            return new class_238(maid.method_18412()).method_1009((double)radius, 4.0, (double)radius);
        }
        return maid.method_5829().method_1009((double)radius, 4.0, (double)radius);
    }

    default public float searchRadius(EntityMaid maid) {
        return maid.method_18413();
    }
}

