/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class TextChatBubbleRenderer
implements IChatBubbleRenderer {
    private static final int MAX_WIDTH = 240;
    private static final int MAX_CENTER_WIDTH = 480;
    private final List<class_5481> split;
    private final class_327 font;
    private final int width;
    private final int height;
    private final class_2960 bg;

    public TextChatBubbleRenderer(class_2561 text, class_2960 bg, IChatBubbleRenderer.Position position) {
        this.font = class_310.method_1551().field_1772;
        if (position == IChatBubbleRenderer.Position.CENTER) {
            this.split = this.font.method_1728((class_5348)text, 480);
            this.width = this.getMaxWidth(this.split);
        } else {
            this.split = this.font.method_1728((class_5348)text, 240);
            this.width = this.getMaxWidth(this.split);
        }
        int n = this.split.size();
        Objects.requireNonNull(this.font);
        this.height = n * 9;
        this.bg = bg;
    }

    private int getMaxWidth(List<class_5481> split) {
        int width = 0;
        for (class_5481 sequence : split) {
            int lineWidth = this.font.method_30880(sequence);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void render(EntityMaidRenderer renderer, EntityGraphics graphics) {
        int y = 0;
        for (class_5481 sequence : this.split) {
            graphics.drawString(this.font, sequence, 0.0f, (float)y, 0, false);
            Objects.requireNonNull(this.font);
            y += 9;
        }
    }

    @Override
    public class_2960 getBackgroundTexture() {
        return this.bg;
    }
}

