/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation;

import cn.sh1rocu.touhoulittlemaid.util.forge.CommonHooks;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_7;
import net.minecraft.class_9;
import net.minecraft.class_9316;

public class MaidNodeEvaluator
extends class_14 {
    public class_7 method_17(class_9316 pContext, int pX, int pY, int pZ) {
        return this.getMaidBlockPathTypeStatic(pContext, new class_2338.class_2339(pX, pY, pZ));
    }

    public int method_18(class_9[] outputArray, class_9 node) {
        int nodeId = super.method_18(outputArray, node);
        return this.createClimbNode(nodeId, outputArray, node);
    }

    protected int createClimbNode(int nodeId, class_9[] nodes, class_9 origin) {
        EntityMaid maid;
        class_1308 class_13082 = this.field_33;
        if (class_13082 instanceof EntityMaid && (maid = (EntityMaid)class_13082).getConfigManager().isActiveClimbing()) {
            class_2338.class_2339 downPos;
            class_2338.class_2339 upPos = new class_2338.class_2339(origin.field_40, origin.field_39 + 1, origin.field_38);
            if (MaidNodeEvaluator.isMaidCanClimbBlock((class_2338)upPos, maid)) {
                class_9 node = this.method_27137((class_2338)upPos);
                if (!node.field_42) {
                    node.field_43 = 0.0f;
                    node.field_41 = class_7.field_12;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
            if (MaidNodeEvaluator.isMaidCanClimbBlock((class_2338)(downPos = new class_2338.class_2339(origin.field_40, origin.field_39 - 1, origin.field_38)), maid)) {
                class_9 node = this.method_27137((class_2338)downPos);
                if (!node.field_42) {
                    node.field_43 = 0.0f;
                    node.field_41 = class_7.field_12;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
        }
        return nodeId;
    }

    private class_7 getMaidBlockPathTypeStatic(class_9316 context, class_2338.class_2339 pos) {
        int z;
        int y;
        int x = pos.method_10263();
        class_7 pathType = this.getMaidBlockPathTypeRaw(context, x, y = pos.method_10264(), z = pos.method_10260());
        if (pathType == class_7.field_7 && y >= context.method_57621().method_31607() + 1) {
            return switch (this.getMaidBlockPathTypeRaw(context, x, y - 1, z)) {
                case class_7.field_7, class_7.field_18, class_7.field_14, class_7.field_12 -> class_7.field_7;
                case class_7.field_3 -> class_7.field_3;
                case class_7.field_17 -> class_7.field_17;
                case class_7.field_21326 -> class_7.field_21326;
                case class_7.field_33534 -> class_7.field_36432;
                case class_7.field_43351 -> class_7.field_43351;
                case class_7.field_19 -> class_7.field_47413;
                default -> MaidNodeEvaluator.method_59((class_9316)context, (int)x, (int)y, (int)z, (class_7)class_7.field_12);
            };
        }
        return pathType;
    }

    private class_7 getMaidBlockPathTypeRaw(class_9316 context, int pX, int pY, int pZ) {
        EntityMaid maid;
        class_1308 class_13082;
        class_7 pathType;
        EntityMaid maid2;
        class_2338 pos = new class_2338(pX, pY, pZ);
        class_1308 class_13083 = this.field_33;
        if (class_13083 instanceof EntityMaid && (maid2 = (EntityMaid)class_13083).method_18411() && !maid2.method_18407(pos)) {
            return class_7.field_22;
        }
        class_2680 blockState = context.method_57623(pos);
        if (blockState.method_26204() instanceof class_2349) {
            pathType = (Boolean)blockState.method_11654((class_2769)class_2349.field_11026) != false ? class_7.field_15 : class_7.field_23;
        } else {
            class_13082 = this.field_33;
            if (class_13082 instanceof EntityMaid && this.canClimb(blockState, pos, maid = (EntityMaid)class_13082)) {
                pathType = class_7.field_12;
            } else {
                pathType = context.method_57622(pX, pY, pZ);
                if (!this.heightCheckExclusions(pathType) && this.field_33 != null) {
                    class_265 shape = blockState.method_26220((class_1922)this.field_33.field_6002, pos);
                    if (pathType != class_7.field_22 && shape.method_1105(class_2350.class_2351.field_11052) - shape.method_1091(class_2350.class_2351.field_11052) > 0.5) {
                        pathType = class_7.field_22;
                    }
                }
            }
        }
        if (pathType == class_7.field_23 && (class_13082 = this.field_33) instanceof EntityMaid) {
            maid = (EntityMaid)class_13082;
            if (!this.canOpenDoor(blockState.method_26204(), maid)) {
                pathType = class_7.field_8;
            }
        }
        return pathType;
    }

    private boolean heightCheckExclusions(class_7 pathType) {
        return pathType == class_7.field_15 || pathType == class_7.field_23;
    }

    private boolean canOpenDoor(class_2248 block, EntityMaid maid) {
        if (block instanceof class_2323) {
            return maid.getConfigManager().isOpenDoor();
        }
        if (block instanceof class_2349) {
            return maid.getConfigManager().isOpenFenceGate();
        }
        return true;
    }

    private boolean canClimb(class_2680 blockState, class_2338 blockPos, EntityMaid maid) {
        if (MaidNodeEvaluator.isMaidCanClimbBlock(blockState, blockPos, maid)) {
            return maid.getConfigManager().isActiveClimbing();
        }
        return false;
    }

    public static boolean isMaidCanClimbBlock(class_2338 blockPos, EntityMaid maid) {
        class_1937 level = maid.field_6002;
        class_2680 blockState = level.method_8320(blockPos);
        return MaidNodeEvaluator.isMaidCanClimbBlock(blockState, blockPos, maid);
    }

    public static boolean isMaidCanClimbBlock(class_2680 blockState, class_2338 blockPos, EntityMaid maid) {
        return CommonHooks.isLadder(blockState, (class_4538)maid.field_6002, blockPos, (class_1309)maid);
    }
}

