/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1928;

public class EntityDeathEvent {
    public static void onEntityDeath() {
        ServerLivingEntityEvents.AFTER_DEATH.register((target, damageSource) -> {
            class_1297 causingEntity = damageSource.method_5529();
            if (causingEntity instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)causingEntity;
                maid.getKillRecordManager().onTargetDeath(maid, target);
            }
        });
    }

    public static void onPlayerCloned() {
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            boolean wasDeath = !alive;
            boolean isKeep = newPlayer.field_6002.method_8450().method_8355(class_1928.field_19389);
            PowerAttachment power = (PowerAttachment)oldPlayer.getAttachedOrCreate(InitDataAttachment.POWER_NUM, () -> new PowerAttachment(0.0f));
            MaidNumAttachment maidNum = (MaidNumAttachment)oldPlayer.getAttachedOrCreate(InitDataAttachment.MAID_NUM, () -> new MaidNumAttachment(0));
            if (wasDeath && !isKeep) {
                power.min(((Double)MiscConfig.PLAYER_DEATH_LOSS_POWER_POINT.get()).floatValue());
            }
            newPlayer.setAttached(InitDataAttachment.POWER_NUM, (Object)power);
            newPlayer.setAttached(InitDataAttachment.MAID_NUM, (Object)maidNum);
        });
    }
}

