package cn.sh1rocu.touhoulittlemaid.util.itemhandler;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class InvWrapper implements IItemHandlerModifiable {
    private final class_1263 inv;

    public InvWrapper(class_1263 inv) {
        this.inv = inv;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;

        InvWrapper that = (InvWrapper) o;

        return getInv().equals(that.getInv());
    }

    @Override
    public int hashCode() {
        return getInv().hashCode();
    }

    @Override
    public int getSlots() {
        return getInv().method_5439();
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        return getInv().method_5438(slot);
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        if (stack.method_7960())
            return class_1799.field_8037;

        class_1799 stackInSlot = getInv().method_5438(slot);

        int m;
        if (!stackInSlot.method_7960()) {
            if (stackInSlot.method_7947() >= Math.min(stackInSlot.method_7914(), getSlotLimit(slot)))
                return stack;

            if (!class_1799.method_31577(stack, stackInSlot))
                return stack;

            if (!getInv().method_5437(slot, stack))
                return stack;

            m = Math.min(stack.method_7914(), getSlotLimit(slot)) - stackInSlot.method_7947();

            if (stack.method_7947() <= m) {
                if (!simulate) {
                    class_1799 copy = stack.method_7972();
                    copy.method_7933(stackInSlot.method_7947());
                    getInv().method_5447(slot, copy);
                    getInv().method_5431();
                }

                return class_1799.field_8037;
            } else {
                // copy the stack to not modify the original one
                stack = stack.method_7972();
                if (!simulate) {
                    class_1799 copy = stack.method_7971(m);
                    copy.method_7933(stackInSlot.method_7947());
                    getInv().method_5447(slot, copy);
                    getInv().method_5431();
                    return stack;
                } else {
                    stack.method_7934(m);
                    return stack;
                }
            }
        } else {
            if (!getInv().method_5437(slot, stack))
                return stack;

            m = Math.min(stack.method_7914(), getSlotLimit(slot));
            if (m < stack.method_7947()) {
                // copy the stack to not modify the original one
                stack = stack.method_7972();
                if (!simulate) {
                    getInv().method_5447(slot, stack.method_7971(m));
                    getInv().method_5431();
                    return stack;
                } else {
                    stack.method_7934(m);
                    return stack;
                }
            } else {
                if (!simulate) {
                    getInv().method_5447(slot, stack);
                    getInv().method_5431();
                }
                return class_1799.field_8037;
            }
        }
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0)
            return class_1799.field_8037;

        class_1799 stackInSlot = getInv().method_5438(slot);

        if (stackInSlot.method_7960())
            return class_1799.field_8037;

        if (simulate) {
            if (stackInSlot.method_7947() < amount) {
                return stackInSlot.method_7972();
            } else {
                class_1799 copy = stackInSlot.method_7972();
                copy.method_7939(amount);
                return copy;
            }
        } else {
            int m = Math.min(stackInSlot.method_7947(), amount);

            class_1799 decrStackSize = getInv().method_5434(slot, m);
            getInv().method_5431();
            return decrStackSize;
        }
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        getInv().method_5447(slot, stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return getInv().method_5444();
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        return getInv().method_5437(slot, stack);
    }

    public class_1263 getInv() {
        return inv;
    }

    @Override
    public void readFromNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 registryLookup) {
        if (tag.method_10545(TAG_INVENTORY)) {
            this.deserializeNBT(registryLookup, tag.method_10562(TAG_INVENTORY));
        }
    }

    @Override
    public void writeToNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 registryLookup) {
        tag.method_10566(TAG_INVENTORY, this.serializeNBT(registryLookup));
    }

    public class_2487 serializeNBT(class_7225.class_7874 provider) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < getSlots(); i++) {
            if (!getStackInSlot(i).method_7960()) {
                class_2487 itemTag = new class_2487();
                itemTag.method_10569("Slot", i);
                nbtTagList.add(getStackInSlot(i).method_57376(provider, itemTag));
            }
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", nbtTagList);
        nbt.method_10569("Size", getSlots());
        return nbt;
    }

    public void deserializeNBT(class_7225.class_7874 provider, class_2487 nbt) {
        int size = nbt.method_10573("Size", class_2520.field_33253) ? nbt.method_10550("Size") : getSlots();
        class_2499 tagList = nbt.method_10554("Items", class_2520.field_33260);
        for (int i = 0; i < tagList.size(); i++) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");

            if (slot >= 0 && slot < size) {
                class_1799.method_57360(provider, itemTags).ifPresent(stack -> setStackInSlot(slot, stack));
            }
        }
    }
}
