package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigPackage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4168;
import net.minecraft.class_4185;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;

public class ScheduleButton<T extends AbstractMaidContainer> extends class_4185 {
    private static final class_2960 BUTTON = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/maid_gui_button.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private final EntityMaid maid;
    private MaidSchedule mode;

    public ScheduleButton(int x, int y, AbstractMaidContainerGui<T> gui) {
/*        super(Button.builder(Component.empty(), (b) -> {
        }).pos(x, y).size(61, 13));*/
        super(x, y, 61, 13, class_2561.method_43473(), button -> {
        }, class_4185.field_40754);
        this.maid = gui.getMaid();
        this.mode = maid.getSchedule();
    }

    @Override
    public void method_25306() {
        int index = mode.ordinal() + 1;
        int length = MaidSchedule.values().length;
        this.mode = MaidSchedule.values()[index % length];
        ClientPlayNetworking.send(new MaidConfigPackage(maid.method_5628(), maid.isHomeModeEnable(), maid.isPickup(), maid.isRideable(), this.mode));
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        graphics.method_25290(BUTTON, this.method_46426(), this.method_46427(), 82, 43 + 14 * mode.ordinal(), this.field_22758, this.field_22759, 256, 256);
    }

    public List<class_2561> getTooltips() {
        int time = (int) (maid.method_37908().method_8532() % 24000L);
        int hour = (time / 1000 + 6) % 24;
        int minute = (time % 1000) * 60 / 1000;
        class_4168 activity = maid.getScheduleDetail();

        List<class_2561> out = Lists.newArrayList();
        out.add(class_2561.method_43470(String.format("§n%s§7 %s:%s", getScheduleTransText(), DECIMAL_FORMAT.format(hour), DECIMAL_FORMAT.format(minute))));
        switch (mode) {
            case ALL:
                out.add(class_2561.method_43470(String.format("§a█ 00:00-24:00 %s", getActivityTransText(class_4168.field_18596))));
                break;
            case NIGHT:
                if (activity == class_4168.field_18596) {
                    out.add(class_2561.method_43470(String.format("§a█ 18:00-06:00 %s", getActivityTransText(class_4168.field_18596))));
                } else {
                    out.add(class_2561.method_43470(String.format("§8█ 18:00-06:00 %s", getActivityTransText(class_4168.field_18596))));
                }

                if (activity == class_4168.field_18597) {
                    out.add(class_2561.method_43470(String.format("§a█ 06:00-14:00 %s", getActivityTransText(class_4168.field_18597))));
                } else {
                    out.add(class_2561.method_43470(String.format("§8█ 06:00-14:00 %s", getActivityTransText(class_4168.field_18597))));
                }

                if (activity == class_4168.field_18595) {
                    out.add(class_2561.method_43470(String.format("§a█ 14:00-18:00 %s", getActivityTransText(class_4168.field_18595))));
                } else {
                    out.add(class_2561.method_43470(String.format("§8█ 14:00-18:00 %s", getActivityTransText(class_4168.field_18595))));
                }
                break;
            case DAY:
            default:
                if (activity == class_4168.field_18596) {
                    out.add(class_2561.method_43470(String.format("§a█ 06:00-18:00 %s", getActivityTransText(class_4168.field_18596))));
                } else {
                    out.add(class_2561.method_43470(String.format("§8█ 06:00-18:00 %s", getActivityTransText(class_4168.field_18596))));
                }

                if (activity == class_4168.field_18595) {
                    out.add(class_2561.method_43470(String.format("§a█ 18:00-22:00 %s", getActivityTransText(class_4168.field_18595))));
                } else {
                    out.add(class_2561.method_43470(String.format("§8█ 18:00-22:00 %s", getActivityTransText(class_4168.field_18595))));
                }

                if (activity == class_4168.field_18597) {
                    out.add(class_2561.method_43470(String.format("§a█ 22:00-06:00 %s", getActivityTransText(class_4168.field_18597))));
                } else {
                    out.add(class_2561.method_43470(String.format("§8█ 22:00-06:00 %s", getActivityTransText(class_4168.field_18597))));
                }
        }
        out.add(class_2561.method_43471("tooltips.touhou_little_maid.schedule.desc"));
        return out;
    }

    public String getScheduleTransText() {
        return class_1074.method_4662("gui.touhou_little_maid.schedule." + mode.name().toLowerCase(Locale.US));
    }

    public String getActivityTransText(class_4168 activity) {
        return class_1074.method_4662("gui.touhou_little_maid.activity." + activity.method_19634());
    }
}
