package com.github.tartaricacid.touhoulittlemaid.client.tooltip;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import org.apache.commons.lang3.StringUtils;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

import static com.github.tartaricacid.touhoulittlemaid.client.event.SpecialMaidRenderEvent.EASTER_EGG_MODEL;
import static com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil.clearMaidDataResidue;

public class ClientMaidTooltip implements class_5684 {
    private final @Nullable MaidModelInfo info;
    private final YsmMaidInfo ysmMaidInfo;
    private final class_5250 name;
    private final String customName;

    public ClientMaidTooltip(ItemMaidTooltip tooltip) {
        this.info = CustomPackLoader.MAID_MODELS.getInfo(tooltip.modelId()).orElse(null);
        this.ysmMaidInfo = tooltip.ysmMaidInfo();
        this.name = getName(this.info, this.ysmMaidInfo);
        this.customName = tooltip.customName();
    }

    public class_5250 getName(MaidModelInfo info, YsmMaidInfo ysmMaidInfo) {
        // 优先使用 YSM 模型名称
        if (YsmCompat.isInstalled() && ysmMaidInfo.isYsmModel()) {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return class_2561.method_43473();
            }
            class_5250 name = class_2561.class_2562.method_10877(ysmMaidInfo.name(), level.method_30349());
            if (name == null || name.equals(class_2561.method_43473())) {
                return class_2561.method_43470(ysmMaidInfo.modelId());
            }
            return name;
        }

        // 然后才是默认模型名
        if (info == null) {
            return class_2561.method_43473();
        }
        return class_2561.method_43471(ParseI18n.getI18nKey(info.getName()));
    }

    @Override
    public int method_32661() {
        return 70;
    }

    @Override
    public int method_32664(class_327 font) {
        return Math.max(font.method_27525(this.name), 50);
    }

    @Override
    public void method_32666(class_327 font, int pX, int pY, class_332 guiGraphics) {
        if (info == null) {
            return;
        }
        class_1937 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }

        class_5455 access = class_310.method_1551().field_1687.method_30349();

        class_5250 customNameComponent = null;
        if (StringUtils.isNotBlank(customName)) {
            customNameComponent = class_2561.class_2562.method_10877(customName, access);
            if (customNameComponent != null) {
                guiGraphics.method_27535(font, customNameComponent.method_27692(class_124.field_1080), pX, pY + 2, 0xFFFFFF);
            }
        } else {
            guiGraphics.method_27535(font, name.method_27692(class_124.field_1080), pX, pY + 2, 0xFFFFFF);
        }

        int width = this.method_32664(font);
        int posX = pX + width / 2;
        int posY = pY + 64;
        double rot = ((System.currentTimeMillis() / 25.0) % 360);
        Quaternionf pose = (new Quaternionf()).rotateZ((float) Math.PI);
        Quaternionf rotation = (new Quaternionf()).rotateY((float) Math.toRadians(rot));
        pose.mul(rotation);
        EntityMaid maid;
        try {
            maid = (EntityMaid) EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> {
                class_1297 e = EntityMaid.TYPE.method_5883(world);
                return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
            });
        } catch (ExecutionException | ClassCastException e) {
            e.printStackTrace();
            return;
        }
        clearMaidDataResidue(maid, false);
        if (StringUtils.isNotBlank(customName)) {
            maid.method_5665(customNameComponent);
        }
        if (info.getEasterEgg() != null) {
            maid.setModelId(EASTER_EGG_MODEL);
        } else {
            maid.setModelId(info.getModelId().toString());
        }

        // YSM 渲染运用
        if (YsmCompat.isInstalled() && ysmMaidInfo.isYsmModel()) {
            maid.setIsYsmModel(true);
            maid.setYsmModel(ysmMaidInfo.modelId(), ysmMaidInfo.textureId(), this.name);
        } else {
            maid.setIsYsmModel(false);
        }

        guiGraphics.method_44379(pX, posY - 50, pX + width, posY);
        class_490.method_48472(guiGraphics, posX, posY, (int) (25 * info.getRenderItemScale()), new Vector3f(), pose, null, maid);
        guiGraphics.method_44380();
    }
}
