package com.github.tartaricacid.touhoulittlemaid.compat.kaleidoscope.crop;

import com.github.tartaricacid.touhoulittlemaid.api.task.ISpecialCropHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.crop.SpecialCropManager;
import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.RiceCropBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5712;
import net.minecraft.class_6088;
import org.jetbrains.annotations.NotNull;

public class RiceCropHandler implements ISpecialCropHandler {
    public static void addCropHandlers(SpecialCropManager manager) {
        RiceCropHandler handler = new RiceCropHandler();
        manager.addSeed(ModItems.RICE_SEED, handler);
        manager.addSeed(ModItems.WILD_RICE_SEED, handler);
        manager.addCrop(ModBlocks.RICE_CROP, handler);
    }

    @Override
    public boolean isSeed(@NotNull class_1799 stack) {
        // 由于种植特殊，暂时无法种植，只能玩家种植
        return false;
    }

    @Override
    public boolean canHarvest(@NotNull EntityMaid maid, @NotNull class_2338 cropPos, @NotNull class_2680 cropState) {
        int location = cropState.method_11654(RiceCropBlock.LOCATION);
        return location == RiceCropBlock.DOWN && cropState.method_11654(RiceCropBlock.field_10835) >= RiceCropBlock.field_31079;
    }

    @Override
    public void harvest(@NotNull EntityMaid maid, @NotNull class_2338 cropPos, @NotNull class_2680 cropState, boolean isDestroyMode) {
        // 无视 isDestroyMode，直接收获
        maid.dropResourcesToMaidInv(cropState, maid.field_6002, cropPos, null, maid, maid.method_6047());
        maid.field_6002.method_20290(class_6088.field_31144, cropPos, class_2248.method_9507(cropState));
        // 直接设置 Age 为 0
        cropState = cropState.method_11657(RiceCropBlock.field_10835, 0);
        maid.field_6002.method_8652(cropPos, cropState, class_2248.field_31036);
        maid.field_6002.method_33596(maid, class_5712.field_28733, cropPos);
    }

    @Override
    public boolean canPlant(@NotNull EntityMaid maid, @NotNull class_2338 basePos, @NotNull class_2680 baseState, @NotNull class_1799 seed) {
        // 由于种植特殊，暂时无法种植，只能玩家种植后，女仆右键收获
        return false;
    }
}