package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidBegTask extends class_4097<EntityMaid> {
    private static final int BEG_DISTANCE = 6;
    private static final int CLOSED_DISTANCE = 2;

    public MaidBegTask() {
        super(ImmutableMap.of(class_4140.field_18442, class_4141.field_18456));
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        return owner.method_18868().method_18904(class_4140.field_18442).map(list ->
                        list.method_38980(owner::method_6171)
                                .filter(class_1309::method_5805)
                                .filter(e -> e.method_24516(owner, BEG_DISTANCE))
                                .filter(e -> owner.method_18407(e.method_24515()))
                                .anyMatch((e) -> holdTemptationItem(owner, e)))
                .orElse(false);
    }

    @Override
    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return checkExtraStartConditions(worldIn, entityIn);
    }

    @Override
    protected boolean method_18915(long gameTime) {
        return false;
    }

    @Override
    protected void tick(class_3218 worldIn, EntityMaid maid, long gameTime) {
        class_1309 owner = maid.method_35057();
        if (owner instanceof class_1657) {
            if (!maid.method_24516(owner, CLOSED_DISTANCE)) {
                class_4215.method_24557(maid, owner, 0.6f, CLOSED_DISTANCE);
            } else {
                class_4215.method_19554(maid, owner);
            }
            maid.setBegging(true);
        }
    }

    @Override
    protected void stop(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setBegging(false);
    }

    private boolean holdTemptationItem(EntityMaid owner, class_1309 e) {
        return owner.getTemptationItem().method_8093(e.method_6047());
    }
}
