package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.ICachedEvaluator;
import com.github.tartaricacid.touhoulittlemaid.util.CenterOffsetBlockPosSet;
import com.google.common.collect.Lists;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_8;
import net.minecraft.class_9;

/**
 * BFS版的寻路算法，用于计算从中心开始扩散的若干个点到中心点的可达性
 */
public class MaidPathFindingBFS {
    private final class_9[] tmpNode = new class_9[20];
    private final CenterOffsetBlockPosSet cachePos;
    private final Queue<class_9> queueNode = Lists.newLinkedList();
    private final class_8 nodeEvaluator;
    private final class_2338 centerPos;
    private final double maxDistance;
    private final int verticalSearchRange;

    private boolean isFinished = false;

    public MaidPathFindingBFS(class_8 nodeEvaluator, class_3218 level, EntityMaid maid) {
        this(nodeEvaluator, level, maid, maid.searchRadius(), 7);
    }

    public MaidPathFindingBFS(class_8 nodeEvaluator, class_3218 level, EntityMaid maid, float maxDistance, int verticalSearchRange) {
        this(nodeEvaluator, level, maid,
                maid.method_18410() ? maid.method_18412() : maid.method_24515(),
                maxDistance, verticalSearchRange);
    }

    @SuppressWarnings("all")
    public MaidPathFindingBFS(class_8 nodeEvaluator, class_3218 level, EntityMaid maid, class_2338 centerPos, float maxDistance, int verticalSearchRange) {
        this.nodeEvaluator = nodeEvaluator;
        this.centerPos = centerPos;
        this.maxDistance = maxDistance;
        this.verticalSearchRange = verticalSearchRange;

        int offset = (int) Math.ceil(this.maxDistance);
        class_1950 region = new class_1950(level,
                centerPos.method_10069(-offset, -verticalSearchRange, -offset),
                centerPos.method_10069(offset, verticalSearchRange, offset));
        this.cachePos = new CenterOffsetBlockPosSet(
                offset + 1, verticalSearchRange + 1, offset + 1,
                centerPos.method_10263(), centerPos.method_10264(), centerPos.method_10260()
        );
        if (nodeEvaluator instanceof ICachedEvaluator ice) {
            ice.init(offset, verticalSearchRange, offset, centerPos.method_10263(), centerPos.method_10264(), centerPos.method_10260());
        }
        nodeEvaluator.method_12(region, maid);
        class_9 start = nodeEvaluator.method_21();
        if (start != null) {
            this.cachePos.markVis(start.method_22879());
            this.queueNode.add(start);
        }
    }

    private boolean canPathReachInternal(class_2338 pos) {
        return this.cachePos.isVis(pos) || this.cachePos.isVis(pos.method_10084());
    }

    public boolean canPathReach(class_2338 pos) {
        if (canPathReachInternal(pos)) {
            return true;
        }
        if (isFinished) {
            return false;
        }
        while (!canPathReachInternal(pos) && !isFinished) {
            searchStep();
        }
        return canPathReachInternal(pos);
    }

    @Nullable
    private class_2338 searchStep() {
        if (isFinished) {
            return null;
        }
        if (queueNode.isEmpty()) {
            isFinished = true;
            return null;
        }
        class_9 node = queueNode.poll();
        int neighbors = this.nodeEvaluator.method_18(tmpNode, node);
        for (int i = 0; i < neighbors; i++) {
            if (cachePos.isVis(tmpNode[i].method_22879())) {
                continue;
            }
            class_2338 offset = tmpNode[i].method_22879().method_10059(centerPos);
            if (verticalSearchRange < offset.method_10264() || offset.method_10264() < -verticalSearchRange) {
                continue;
            }
            double neighborDistance = offset.method_10263() * offset.method_10263() + offset.method_10260() * offset.method_10260();
            if (neighborDistance > maxDistance * maxDistance) {
                continue;
            }
            cachePos.markVis(tmpNode[i].method_22879());
            if (this.nodeEvaluator instanceof ICachedEvaluator ice) {
                ice.markVis(tmpNode[i].method_22879());
            }
            queueNode.add(tmpNode[i]);
        }
        return node.method_22879();
    }

    public Optional<class_2338> find(Predicate<class_2338> predicate) {
        while (!isFinished) {
            class_2338 blockPos = searchStep();
            if (blockPos != null && predicate.test(blockPos)) {
                return Optional.of(blockPos);
            }
        }
        return Optional.empty();
    }

    public void finish() {
        this.isFinished = true;
        this.nodeEvaluator.method_19();
    }
}
