package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.*;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.VectorUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_4587;

public class GeoCube {
    public final List<GeoQuad> quads = new ObjectArrayList<>(6);
    public final Vector3f size = new Vector3f();

    private GeoCube(double[] size) {
        if (size.length >= 3) {
            this.size.set((float) size[0], (float) size[1], (float) size[2]);
        }
    }

    public static GeoCube createFromPojoCube(Cube cubeIn, ModelProperties properties, Double boneInflate, Boolean mirror) {
        GeoCube cube = new GeoCube(cubeIn.getSize());

        UvUnion uvUnion = cubeIn.getUv();
        UvFaces faces = uvUnion.faceUV;
        boolean isBoxUV = uvUnion.isBoxUV;
        double inflate = cubeIn.getInflate() == null ? (boneInflate == null ? 0 : boneInflate) : cubeIn.getInflate() / 16;

        float textureHeight = properties.getTextureHeight().floatValue();
        float textureWidth = properties.getTextureWidth().floatValue();

        class_243 size = VectorUtils.fromArray(cubeIn.getSize());
        class_243 origin = VectorUtils.fromArray(cubeIn.getOrigin());
        origin = new class_243(-(origin.field_1352 + size.field_1352) / 16, origin.field_1351 / 16, origin.field_1350 / 16);

        size = size.method_18805(0.0625f, 0.0625, 0.0625f);

        Vector3f rotation = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getRotation()));
        rotation.mul(-1, -1, 1);

        rotation.set((float) Math.toRadians(rotation.x()), (float) Math.toRadians(rotation.y()), (float) Math.toRadians(rotation.z()));

        Vector3f pivot = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getPivot()));
        pivot.mul(-1, 1, 1);

        GeoVertex P1 = new GeoVertex(origin.field_1352 - inflate, origin.field_1351 - inflate, origin.field_1350 - inflate);
        GeoVertex P2 = new GeoVertex(origin.field_1352 - inflate, origin.field_1351 - inflate,
                origin.field_1350 + size.field_1350 + inflate);
        GeoVertex P3 = new GeoVertex(origin.field_1352 - inflate, origin.field_1351 + size.field_1351 + inflate,
                origin.field_1350 - inflate);
        GeoVertex P4 = new GeoVertex(origin.field_1352 - inflate, origin.field_1351 + size.field_1351 + inflate,
                origin.field_1350 + size.field_1350 + inflate);
        GeoVertex P5 = new GeoVertex(origin.field_1352 + size.field_1352 + inflate, origin.field_1351 - inflate,
                origin.field_1350 - inflate);
        GeoVertex P6 = new GeoVertex(origin.field_1352 + size.field_1352 + inflate, origin.field_1351 - inflate,
                origin.field_1350 + size.field_1350 + inflate);
        GeoVertex P7 = new GeoVertex(origin.field_1352 + size.field_1352 + inflate, origin.field_1351 + size.field_1351 + inflate,
                origin.field_1350 - inflate);
        GeoVertex P8 = new GeoVertex(origin.field_1352 + size.field_1352 + inflate, origin.field_1351 + size.field_1351 + inflate,
                origin.field_1350 + size.field_1350 + inflate);

        GeoQuad quadWest;
        GeoQuad quadEast;
        GeoQuad quadNorth;
        GeoQuad quadSouth;
        GeoQuad quadUp;
        GeoQuad quadDown;

        if (!isBoxUV) {
            FaceUv west = faces.getWest();
            FaceUv east = faces.getEast();
            FaceUv north = faces.getNorth();
            FaceUv south = faces.getSouth();
            FaceUv up = faces.getUp();
            FaceUv down = faces.getDown();

            quadWest = west == null ? null
                    : new GeoQuad(new GeoVertex[]{P4, P3, P1, P2}, west.getUv(), west.getUvSize(), textureWidth,
                    textureHeight, cubeIn.getMirror(), class_2350.field_11039);
            quadEast = east == null ? null
                    : new GeoQuad(new GeoVertex[]{P7, P8, P6, P5}, east.getUv(), east.getUvSize(), textureWidth,
                    textureHeight, cubeIn.getMirror(), class_2350.field_11034);
            quadNorth = north == null ? null
                    : new GeoQuad(new GeoVertex[]{P3, P7, P5, P1}, north.getUv(), north.getUvSize(), textureWidth,
                    textureHeight, cubeIn.getMirror(), class_2350.field_11043);
            quadSouth = south == null ? null
                    : new GeoQuad(new GeoVertex[]{P8, P4, P2, P6}, south.getUv(), south.getUvSize(), textureWidth,
                    textureHeight, cubeIn.getMirror(), class_2350.field_11035);
            quadUp = up == null ? null
                    : new GeoQuad(new GeoVertex[]{P4, P8, P7, P3}, up.getUv(), up.getUvSize(), textureWidth,
                    textureHeight, cubeIn.getMirror(), class_2350.field_11036);
            quadDown = down == null ? null
                    : new GeoQuad(new GeoVertex[]{P1, P5, P6, P2}, down.getUv(), down.getUvSize(), textureWidth,
                    textureHeight, cubeIn.getMirror(), class_2350.field_11033);

            if (Boolean.TRUE.equals(cubeIn.getMirror()) || Boolean.TRUE.equals(mirror)) {
                quadWest = west == null ? null
                        : new GeoQuad(new GeoVertex[]{P7, P8, P6, P5}, west.getUv(), west.getUvSize(), textureWidth,
                        textureHeight, cubeIn.getMirror(), class_2350.field_11039);
                quadEast = east == null ? null
                        : new GeoQuad(new GeoVertex[]{P4, P3, P1, P2}, east.getUv(), east.getUvSize(), textureWidth,
                        textureHeight, cubeIn.getMirror(), class_2350.field_11034);
                quadNorth = north == null ? null
                        : new GeoQuad(new GeoVertex[]{P3, P7, P5, P1}, north.getUv(), north.getUvSize(), textureWidth,
                        textureHeight, cubeIn.getMirror(), class_2350.field_11043);
                quadSouth = south == null ? null
                        : new GeoQuad(new GeoVertex[]{P8, P4, P2, P6}, south.getUv(), south.getUvSize(), textureWidth,
                        textureHeight, cubeIn.getMirror(), class_2350.field_11035);
                quadUp = up == null ? null
                        : new GeoQuad(new GeoVertex[]{P1, P5, P6, P2}, up.getUv(), up.getUvSize(), textureWidth,
                        textureHeight, cubeIn.getMirror(), class_2350.field_11036);
                quadDown = down == null ? null
                        : new GeoQuad(new GeoVertex[]{P4, P8, P7, P3}, down.getUv(), down.getUvSize(), textureWidth,
                        textureHeight, cubeIn.getMirror(), class_2350.field_11033);
            }
        } else {
            double[] uv = cubeIn.getUv().boxUVCoords;
            class_243 uvSize = VectorUtils.fromArray(cubeIn.getSize());
            uvSize = new class_243(Math.floor(uvSize.field_1352), Math.floor(uvSize.field_1351), Math.floor(uvSize.field_1350));

            quadWest = new GeoQuad(new GeoVertex[]{P4, P3, P1, P2},
                    new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1350, uvSize.field_1351},
                    textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11039);
            quadEast = new GeoQuad(new GeoVertex[]{P7, P8, P6, P5}, new double[]{uv[0], uv[1] + uvSize.field_1350},
                    new double[]{uvSize.field_1350, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(),
                    class_2350.field_11034);
            quadNorth = new GeoQuad(new GeoVertex[]{P3, P7, P5, P1},
                    new double[]{uv[0] + uvSize.field_1350, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1352, uvSize.field_1351},
                    textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11043);
            quadSouth = new GeoQuad(new GeoVertex[]{P8, P4, P2, P6},
                    new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352 + uvSize.field_1350, uv[1] + uvSize.field_1350},
                    new double[]{uvSize.field_1352, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(),
                    class_2350.field_11035);
            quadUp = new GeoQuad(new GeoVertex[]{P4, P8, P7, P3}, new double[]{uv[0] + uvSize.field_1350, uv[1]},
                    new double[]{uvSize.field_1352, uvSize.field_1350}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11036);
            quadDown = new GeoQuad(new GeoVertex[]{P1, P5, P6, P2},
                    new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352, uv[1] + uvSize.field_1350},
                    new double[]{uvSize.field_1352, -uvSize.field_1350}, textureWidth, textureHeight, cubeIn.getMirror(),
                    class_2350.field_11033);

            if (Boolean.TRUE.equals(cubeIn.getMirror()) || Boolean.TRUE.equals(mirror)) {
                quadWest = new GeoQuad(new GeoVertex[]{P7, P8, P6, P5},
                        new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352, uv[1] + uvSize.field_1350},
                        new double[]{uvSize.field_1350, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(),
                        class_2350.field_11039);
                quadEast = new GeoQuad(new GeoVertex[]{P4, P3, P1, P2}, new double[]{uv[0], uv[1] + uvSize.field_1350},
                        new double[]{uvSize.field_1350, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(),
                        class_2350.field_11034);
                quadNorth = new GeoQuad(new GeoVertex[]{P3, P7, P5, P1},
                        new double[]{uv[0] + uvSize.field_1350, uv[1] + uvSize.field_1350}, new double[]{uvSize.field_1352, uvSize.field_1351},
                        textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11043);
                quadSouth = new GeoQuad(new GeoVertex[]{P8, P4, P2, P6},
                        new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352 + uvSize.field_1350, uv[1] + uvSize.field_1350},
                        new double[]{uvSize.field_1352, uvSize.field_1351}, textureWidth, textureHeight, cubeIn.getMirror(),
                        class_2350.field_11035);
                quadUp = new GeoQuad(new GeoVertex[]{P4, P8, P7, P3}, new double[]{uv[0] + uvSize.field_1350, uv[1]},
                        new double[]{uvSize.field_1352, uvSize.field_1350}, textureWidth, textureHeight, cubeIn.getMirror(), class_2350.field_11036);
                quadDown = new GeoQuad(new GeoVertex[]{P1, P5, P6, P2},
                        new double[]{uv[0] + uvSize.field_1350 + uvSize.field_1352, uv[1] + uvSize.field_1350},
                        new double[]{uvSize.field_1352, -uvSize.field_1350}, textureWidth, textureHeight, cubeIn.getMirror(),
                        class_2350.field_11033);
            }
        }

        if (quadWest != null) {
            cube.quads.add(quadWest);
        }
        if (quadEast != null) {
            cube.quads.add(quadEast);
        }
        if (quadNorth != null) {
            cube.quads.add(quadNorth);
        }
        if (quadSouth != null) {
            cube.quads.add(quadSouth);
        }
        if (quadUp != null) {
            cube.quads.add(quadUp);
        }
        if (quadDown != null) {
            cube.quads.add(quadDown);
        }

        class_4587 poseStack = new class_4587();
        poseStack.method_49278(new Quaternionf().rotateZYX(rotation.z(), rotation.y(), rotation.x()), pivot.x() / 16f, pivot.y() / 16f, pivot.z() / 16f);

        for (var quad : cube.quads) {
            quad.normal.mul(poseStack.method_23760().method_23762());
            for (var vertex : quad.vertices) {
                var vec4 = new Vector4f(vertex.position.x, vertex.position.y, vertex.position.z, 1);
                vec4.mul(poseStack.method_23760().method_23761());
                vertex.position.set(vec4.x, vec4.y, vec4.z);
            }
        }

        return cube;
    }
}
