package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4215;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record MaidConfigPackage(int id, boolean home, boolean pick, boolean ride,
                                MaidSchedule schedule) implements class_8710 {
    public static final class_8710.class_9154<MaidConfigPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("maid_config"));
    public static final class_9139<ByteBuf, MaidConfigPackage> STREAM_CODEC = class_9139.method_56906(
            class_9135.field_48550,
            MaidConfigPackage::id,
            class_9135.field_48547,
            MaidConfigPackage::home,
            class_9135.field_48547,
            MaidConfigPackage::pick,
            class_9135.field_48547,
            MaidConfigPackage::ride,
            MaidSchedule.STREAM_CODEC,
            MaidConfigPackage::schedule,
            MaidConfigPackage::new
    );

    public static void handle(MaidConfigPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            class_1297 entity = sender.field_6002.method_8469(message.id);
            if (entity instanceof EntityMaid maid && maid.method_6171(sender)) {
                if (maid.isHomeModeEnable() != message.home) {
                    handleHome(message, sender, maid);
                }
                if (maid.isPickup() != message.pick) {
                    maid.setPickup(message.pick);
                }
                if (maid.isRideable() != message.ride) {
                    maid.setRideable(message.ride);
                    class_1297 vehicle = maid.method_5854();
                    if (!message.ride && vehicle != null && !isStopRideBlocklist(vehicle)) {
                        maid.method_5848();
                    }
                }
                if (maid.getSchedule() != message.schedule) {
                    maid.setSchedule(message.schedule);
                    maid.getSchedulePos().restrictTo(maid);
                    if (maid.isHomeModeEnable()) {
                        class_4215.method_24561(maid, maid.method_18412(), 0.7f, 3);
                    }
                    if (maid.method_35057() instanceof class_3222 serverPlayer) {
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.SWITCH_SCHEDULE);
                    }
                }
            }
        });
    }

    private static boolean isStopRideBlocklist(class_1297 vehicle) {
        // 娱乐方块骑乘不受影响
        boolean isSit = vehicle instanceof EntitySit;
        // 飞行中的扫帚不能脱离，有风险
        boolean isBroom = vehicle instanceof EntityBroom broom && !broom.method_24828();
        return isSit || isBroom;
    }

    private static void handleHome(MaidConfigPackage message, class_3222 sender, EntityMaid maid) {
        if (message.home) {
            SchedulePos schedulePos = maid.getSchedulePos();
            if (schedulePos.isConfigured()) {
                class_2960 dimension = schedulePos.getDimension();
                if (!dimension.equals(maid.field_6002.method_27983().method_29177())) {
                    CheckSchedulePosPacket tips = new CheckSchedulePosPacket("message.touhou_little_maid.check_schedule_pos.dimension");
                    ServerPlayNetworking.send(sender, tips);
                    return;
                }
                class_2338 nearestPos = schedulePos.getNearestPos(maid);
                if (nearestPos != null && nearestPos.method_10262(maid.method_24515()) > 32 * 32) {
                    CheckSchedulePosPacket tips = new CheckSchedulePosPacket("message.touhou_little_maid.check_schedule_pos.too_far");
                    ServerPlayNetworking.send(sender, tips);
                    return;
                }
            }
            schedulePos.setHomeModeEnable(maid, maid.method_24515());
        } else {
            maid.method_18408(class_2338.field_10980, MaidConfig.MAID_NON_HOME_RANGE.get());
        }
        maid.setHomeModeEnable(message.home);
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}