package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record MaidModelPackage(int id, class_2960 modelId) implements class_8710 {
    public static final class_8710.class_9154<MaidModelPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("maid_model"));
    public static final class_9139<ByteBuf, MaidModelPackage> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_48550,
            MaidModelPackage::id,
            class_2960.field_48267,
            MaidModelPackage::modelId,
            MaidModelPackage::new
    );

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(MaidModelPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            class_1297 entity = sender.field_6002.method_8469(message.id);
            if (entity instanceof EntityMaid maid && maid.method_6171(sender)) {
                if (sender.method_7337() || MaidConfig.MAID_CHANGE_MODEL.get()) {
                    maid.setIsYsmModel(false);
                    maid.setModelId(message.modelId.toString());
                    InitTrigger.MAID_EVENT.trigger(sender, TriggerType.CHANGE_MAID_MODEL);
                } else {
                    sender.method_43496(class_2561.method_43471("message.touhou_little_maid.change_model.disabled"));
                }
            }
        });
    }
}
