package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.TankBackpackContainer;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record SyncFluidAmountPackage(int amount) implements class_8710 {
    public static final class_8710.class_9154<SyncFluidAmountPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("client_sync_fluid_amount"));
    public static final class_9139<ByteBuf, SyncFluidAmountPackage> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48550,
            SyncFluidAmountPackage::amount,
            SyncFluidAmountPackage::new
    );

    public static void handle(SyncFluidAmountPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> {
            if (context.player().field_7512 instanceof TankBackpackContainer tankBackpackContainer) {
                tankBackpackContainer.setClientFluidCount(message.amount);
            }
        });
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
