/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.model.DebugFloorModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.Rectangle;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AbstractModelDetailsGui<T extends class_1309, E extends IModelInfo>
extends class_437 {
    private static final class_2960 BUTTON_TEXTURE = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/gui/skin_detail.png");
    private static final class_2960 FLOOR_TEXTURE = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/entity/debug_floor.png");
    private static final int LEFT_MOUSE_BUTTON = 0;
    private static final int RIGHT_MOUSE_BUTTON = 1;
    private static final float SCALE_MAX = 360.0f;
    private static final float SCALE_MIN = 18.0f;
    private static final float PITCH_MAX = 90.0f;
    private static final float PITCH_MIN = -90.0f;
    private static Rectangle BACKGROUND_SIZE;
    private static Rectangle BOTTOM_STATUS_BAR_SIZE;
    private static Rectangle SIDE_MENU_SIZE;
    private static Rectangle TOP_STATUS_BAR_SIZE;
    protected final DebugFloorModel floorModel;
    protected T sourceEntity;
    protected volatile T guiEntity;
    protected E modelInfo;
    private float posX = 0.0f;
    private float posY = 25.0f;
    private float scale = 80.0f;
    private float yaw = 145.0f;
    private float pitch = 0.0f;
    private boolean showFloor = true;

    public AbstractModelDetailsGui(T sourceEntity, @Nullable T guiEntity, E modelInfo) {
        super((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.custom_model_details_gui.title"));
        this.sourceEntity = sourceEntity;
        this.guiEntity = guiEntity;
        this.modelInfo = modelInfo;
        this.floorModel = new DebugFloorModel(class_310.method_1551().method_31974().method_32072(DebugFloorModel.LAYER));
    }

    protected abstract void applyReturnButtonLogic();

    protected abstract void initSideButton();

    protected abstract void renderExtraEntity(class_898 var1, class_4587 var2, class_4597.class_4598 var3);

    protected void method_25426() {
        this.method_37067();
        BACKGROUND_SIZE = new Rectangle(0.0, 0.0, this.field_22789, this.field_22790);
        BOTTOM_STATUS_BAR_SIZE = new Rectangle(0.0, this.field_22790 - 16, this.field_22789, this.field_22790);
        SIDE_MENU_SIZE = new Rectangle(0.0, 0.0, 132.0, this.field_22790);
        TOP_STATUS_BAR_SIZE = new Rectangle(0.0, 0.0, this.field_22789, 15.0);
        TouhouImageButton closeButton = new TouhouImageButton(this.field_22789 - 15, 0, 15, 15, 0, 24, 15, BUTTON_TEXTURE, b -> class_310.method_1551().method_1507(null));
        TouhouImageButton floorButton = new TouhouImageButton(this.field_22789 - 30, 0, 15, 15, 30, 24, 15, BUTTON_TEXTURE, b -> {
            this.showFloor = !this.showFloor;
        });
        TouhouImageButton returnButton = new TouhouImageButton(this.field_22789 - 45, 0, 15, 15, 15, 24, 15, BUTTON_TEXTURE, b -> this.applyReturnButtonLogic());
        this.method_37063((class_364)closeButton);
        this.method_37063((class_364)floorButton);
        this.method_37063((class_364)returnButton);
        this.initSideButton();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22787 == null) {
            return;
        }
        this.renderViewBg(graphics);
        this.renderEntity((this.field_22789 + 132) / 2, this.field_22790 / 2 + 50, graphics);
        this.renderBottomStatueBar(graphics);
        this.fillGradient(graphics, SIDE_MENU_SIZE, -31382229);
        this.fillGradient(graphics, TOP_STATUS_BAR_SIZE, -30921676);
        graphics.method_27535(this.field_22793, this.method_25440(), 6, 4, -5592406);
        for (class_4068 renderable : ((ScreenAccessor)((Object)this)).tlm$getRenderables()) {
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void renderViewBg(class_332 graphics) {
        this.fillGradient(graphics, BACKGROUND_SIZE, -32040675, -999);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, -900.0f);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.skin_details.left_mouse"), (int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4, (int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 4, -5592406, false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.skin_details.right_mouse"), (int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4, (int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 14, -5592406, false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.skin_details.mouse_wheel"), (int)AbstractModelDetailsGui.SIDE_MENU_SIZE.w + 4, (int)AbstractModelDetailsGui.TOP_STATUS_BAR_SIZE.h + 24, -5592406, false);
        graphics.method_51448().method_22909();
    }

    private void renderBottomStatueBar(class_332 graphics) {
        this.fillGradient(graphics, BOTTOM_STATUS_BAR_SIZE, -30921676);
        String name = String.format("%s %s", "\u2714", class_1074.method_4662((String)ParseI18n.getI18nKey(this.modelInfo.getName()), (Object[])new Object[0]));
        String info = String.format("%d FPS %.2f%%", class_310.field_1738, Float.valueOf(this.scale * 100.0f / 80.0f));
        graphics.method_51433(this.field_22793, name, 136, this.field_22790 - 12, 13290196, false);
        graphics.method_51433(this.field_22793, info, this.field_22789 - this.field_22793.method_1727(info) - 4, this.field_22790 - 12, 13290196, false);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean isInRange;
        boolean isInWidthRange = 132.0 < mouseX && mouseX < (double)(this.field_22789 - 1);
        boolean isInHeightRange = 15.0 < mouseY && mouseY < (double)(this.field_22790 - 16);
        boolean bl = isInRange = isInWidthRange && isInHeightRange;
        if (this.field_22787 == null || !isInRange) {
            return false;
        }
        if (button == 0) {
            this.yaw = (float)((double)this.yaw + dragX);
            this.changePitchValue((float)dragY);
        }
        if (button == 1) {
            this.posX = (float)((double)this.posX + dragX);
            this.posY = (float)((double)this.posY + dragY);
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        boolean isInRange;
        boolean isInWidthRange = 132.0 < mouseX && mouseX < (double)(this.field_22789 - 1);
        boolean isInHeightRange = 15.0 < mouseY && mouseY < (double)(this.field_22790 - 16);
        boolean bl = isInRange = isInWidthRange && isInHeightRange;
        if (this.field_22787 == null || !isInRange) {
            return false;
        }
        if (deltaY != 0.0) {
            this.changeScaleValue((float)deltaY * 0.07f);
            return true;
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    private void changePitchValue(float amount) {
        this.pitch = this.pitch - amount > 90.0f ? 90.0f : (this.pitch - amount < -90.0f ? -90.0f : (this.pitch -= amount));
    }

    private void changeScaleValue(float amount) {
        float tmp = this.scale + amount * this.scale;
        this.scale = class_3532.method_15363((float)tmp, (float)18.0f, (float)360.0f);
    }

    private void renderEntity(int middleWidth, int middleHeight, class_332 graphics) {
        graphics.method_44379(132, 15, this.field_22789, this.field_22790 - 16);
        class_4587 viewStack = graphics.method_51448();
        viewStack.method_22903();
        viewStack.method_22904(0.0, 0.0, 1050.0);
        viewStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 poseStack = new class_4587();
        poseStack.method_22904((double)(this.posX + (float)middleWidth), (double)(this.posY + (float)middleHeight), 1000.0);
        poseStack.method_22905(this.scale, this.scale, -this.scale);
        Quaternionf zp = class_7833.field_40718.rotationDegrees(-180.0f);
        Quaternionf yp = class_7833.field_40716.rotationDegrees(this.yaw);
        Quaternionf xp = class_7833.field_40714.rotationDegrees(-this.pitch);
        yp.mul((Quaternionfc)xp);
        zp.mul((Quaternionfc)yp);
        poseStack.method_22907(zp);
        class_308.method_34742();
        class_898 manager = class_310.method_1551().method_1561();
        xp.conjugate();
        manager.method_24196(xp);
        manager.method_3948(false);
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> {
            manager.method_3954(this.guiEntity, 0.0, 0.0, 0.0, 0.0f, class_310.method_1551().method_60646().method_60637(false), poseStack, (class_4597)buffer, 0xF000F0);
            poseStack.method_22904(0.0, 0.5, 0.0);
            if (this.showFloor) {
                this.floorModel.renderToBuffer(poseStack, buffer.getBuffer(this.floorModel.method_23500(FLOOR_TEXTURE)), 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            this.renderExtraEntity(manager, poseStack, buffer);
        });
        buffer.method_22993();
        manager.method_3948(true);
        viewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        graphics.method_44380();
    }

    public boolean method_25421() {
        return false;
    }

    private void fillGradient(class_332 graphics, Rectangle vec4d, int color) {
        graphics.method_25296((int)vec4d.x, (int)vec4d.y, (int)vec4d.w, (int)vec4d.h, color, color);
    }

    private void fillGradient(class_332 graphics, Rectangle vec4d, int color, int zLevel) {
        graphics.method_33284((int)vec4d.x, (int)vec4d.y, (int)vec4d.w, (int)vec4d.h, zLevel, color, color);
    }
}

