/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail.ChairModelDetailsGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.AbstractModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.network.message.ChairModelPackage;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_638;
import net.minecraft.class_8710;

public class ChairModelGui
extends AbstractModelGui<EntityChair, ChairModelInfo> {
    private static int PAGE_INDEX = 0;
    private static int PACK_INDEX = 0;
    private static int ROW_INDEX = 0;

    public ChairModelGui(EntityChair entity) {
        super(entity, CustomPackLoader.CHAIR_MODELS.getPackList());
    }

    @Override
    protected void drawLeftEntity(class_332 graphics, int middleX, int middleY, float mouseX, float mouseY) {
        float renderItemScale = CustomPackLoader.CHAIR_MODELS.getModelRenderItemScale(((EntityChair)this.entity).getModelId());
        int centerX = (middleX - 128) / 2;
        int centerY = middleY + 80;
        class_490.method_2486((class_332)graphics, (int)(centerX - 68), (int)(centerY - 100), (int)(centerX + 68), (int)(centerY + 80), (int)((int)(45.0f * renderItemScale)), (float)0.0f, (float)(centerX + 25), (float)(centerY + 5), (class_1309)this.entity);
    }

    @Override
    protected void drawRightEntity(class_332 graphics, int posX, int posY, ChairModelInfo modelItem) {
        class_2960 cacheIconId = modelItem.getCacheIconId();
        Map allTextures = class_310.method_1551().method_1531().field_5286;
        if (((Boolean)MiscConfig.MODEL_ICON_CACHE.get()).booleanValue() && allTextures.containsKey(cacheIconId)) {
            int textureSize = 24;
            graphics.method_25293(cacheIconId, posX - textureSize / 2, posY - textureSize, textureSize, textureSize, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
        } else {
            this.drawEntity(graphics, posX, posY, modelItem);
        }
    }

    @Override
    protected void openDetailsGui(EntityChair entity, ChairModelInfo modelInfo) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new ChairModelDetailsGui(entity, modelInfo));
        }
    }

    @Override
    protected void notifyModelChange(EntityChair entity, ChairModelInfo modelInfo) {
        ClientPlayNetworking.send((class_8710)new ChairModelPackage(entity.method_5628(), modelInfo.getModelId(), modelInfo.getMountedYOffset(), modelInfo.isTameableCanRide(), modelInfo.isNoGravity()));
    }

    @Override
    protected void addModelCustomTips(ChairModelInfo modelItem, List<class_2561> tooltips) {
    }

    @Override
    protected int getPageIndex() {
        return PAGE_INDEX;
    }

    @Override
    protected void setPageIndex(int pageIndex) {
        PAGE_INDEX = pageIndex;
    }

    @Override
    protected int getPackIndex() {
        return PACK_INDEX;
    }

    @Override
    protected void setPackIndex(int packIndex) {
        PACK_INDEX = packIndex;
    }

    @Override
    protected int getRowIndex() {
        return ROW_INDEX;
    }

    @Override
    protected void setRowIndex(int rowIndex) {
        ROW_INDEX = rowIndex;
    }

    private void drawEntity(class_332 graphics, int posX, int posY, ChairModelInfo modelItem) {
        EntityChair chair;
        class_638 world = Screens.getClient((class_437)this).field_1687;
        if (world == null) {
            return;
        }
        try {
            chair = (EntityChair)EntityCacheUtil.ENTITY_CACHE.get(EntityChair.TYPE, () -> ChairModelGui.lambda$drawEntity$0((class_1937)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        chair.setModelId(modelItem.getModelId().toString());
        class_490.method_2486((class_332)graphics, (int)(posX - 18), (int)(posY - 30), (int)(posX + 18), (int)(posY + 18), (int)((int)(12.0f * modelItem.getRenderItemScale())), (float)0.0f, (float)(posX + 25), (float)(posY + 5), (class_1309)chair);
    }

    private static /* synthetic */ class_1297 lambda$drawEntity$0(class_1937 world) throws Exception {
        class_1297 e = EntityChair.TYPE.method_5883(world);
        if (e == null) {
            return new EntityChair(world);
        }
        return e;
    }
}

