/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.CChessPiecesModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityCChess;
import com.github.tartaricacid.touhoulittlemaid.util.CChessUtil;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class TileEntityCChessRenderer
implements class_827<TileEntityCChess> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/bedrock/block/cchess.png");
    private static final class_2960 PIECES_TEXTURE = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/bedrock/block/cchess_pieces.png");
    private static final int TIPS_RENDER_DISTANCE = 16;
    private static final int PIECE_RENDER_DISTANCE = 24;
    private final class_327 font;
    private final class_824 dispatcher;
    private final SimpleBedrockModel<class_1297> chessModel = BedrockModelLoader.getModel(BedrockModelLoader.CCHESS);
    private final CChessPiecesModel[] chessPiecesModels = CChessPiecesModel.initModel();
    private final CChessPiecesModel selectedModels = CChessPiecesModel.getSelectedModel();

    public TileEntityCChessRenderer(class_5614.class_5615 context) {
        this.dispatcher = context.method_32139();
        this.font = context.method_32143();
    }

    public void render(TileEntityCChess cchess, float pPartialTick, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_2350 facing = (class_2350)cchess.method_11010().method_11654((class_2769)BlockGomoku.FACING);
        this.renderChessboard(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, facing);
        this.renderPiece(cchess, poseStack, bufferIn, combinedLightIn, combinedOverlayIn, facing);
        this.renderTipsText(cchess, poseStack, bufferIn, combinedLightIn);
    }

    private void renderTipsText(TileEntityCChess chess, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn) {
        boolean showTips;
        boolean bl = showTips = chess.isCheckmate() || chess.isRepeat() || chess.isMoveNumberLimit();
        if (!showTips || !this.inRenderDistance(chess, 16)) {
            return;
        }
        class_4184 camera = this.dispatcher.field_4344;
        class_5250 loseTips = null;
        class_5250 resetTips = class_2561.method_43471((String)"message.touhou_little_maid.cchess.reset").method_27692(class_124.field_1073).method_27692(class_124.field_1075);
        class_5250 roundText = class_2561.method_43469((String)"message.touhou_little_maid.gomoku.round", (Object[])new Object[]{chess.getChessCounter()}).method_27692(class_124.field_1068);
        class_5250 preRoundIcon = class_2561.method_43470((String)"\u23f9 ").method_27692(class_124.field_1060);
        class_5250 postRoundIcon = class_2561.method_43470((String)" \u23f9").method_27692(class_124.field_1060);
        class_5250 roundTips = preRoundIcon.method_10852((class_2561)roundText).method_10852((class_2561)postRoundIcon);
        if (chess.isCheckmate()) {
            loseTips = !chess.isPlayerTurn() ? class_2561.method_43471((String)"message.touhou_little_maid.gomoku.win").method_27692(class_124.field_1067).method_27692(class_124.field_1064) : class_2561.method_43471((String)"message.touhou_little_maid.gomoku.lose").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
        } else if (chess.isMoveNumberLimit()) {
            loseTips = class_2561.method_43471((String)"message.touhou_little_maid.cchess.move_limit").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
        } else if (chess.isRepeat()) {
            loseTips = class_2561.method_43471((String)"message.touhou_little_maid.cchess.repeat").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
        }
        if (loseTips == null) {
            return;
        }
        float loseTipsWidth = -this.font.method_27525((class_5348)loseTips) / 2;
        float resetTipsWidth = -this.font.method_27525((class_5348)resetTips) / 2;
        float roundTipsWidth = -this.font.method_27525((class_5348)roundTips) / 2;
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.75, 0.5);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f + camera.method_19330()));
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(camera.method_19329()));
        poseStack.method_22905(0.03f, -0.03f, 0.03f);
        this.font.method_30882((class_2561)loseTips, loseTipsWidth, -10.0f, 0xFFFFFF, true, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        this.font.method_30882((class_2561)roundTips, roundTipsWidth, -30.0f, 0xFFFFFF, true, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
        this.font.method_30882((class_2561)resetTips, resetTipsWidth, 0.0f, 0xFFFFFF, true, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
        poseStack.method_22909();
    }

    private void renderPiece(TileEntityCChess cchess, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, class_2350 facing) {
        if (this.inRenderDistance(cchess, 24)) {
            class_4588 piecesBuff = bufferIn.getBuffer(class_1921.method_23578((class_2960)PIECES_TEXTURE));
            int selectX = Position.FILE_X(cchess.getSelectChessPoint());
            int selectY = Position.RANK_Y(cchess.getSelectChessPoint());
            byte[] data = cchess.getChessData().squares;
            poseStack.method_22903();
            switch (facing) {
                case field_11043: {
                    poseStack.method_22904(1.865, 1.625, 1.87);
                    break;
                }
                case field_11034: {
                    poseStack.method_22904(-0.865, 1.625, 1.87);
                    break;
                }
                case field_11039: {
                    poseStack.method_22904(1.865, 1.625, -0.8700000000000001);
                    break;
                }
                default: {
                    poseStack.method_22904(-0.865, 1.625, -0.8700000000000001);
                }
            }
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
            poseStack.method_22907(class_7833.field_40715.rotationDegrees((float)(facing.method_10161() * 90)));
            if (facing == class_2350.field_11035 || facing == class_2350.field_11043) {
                poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
            }
            for (int y = 3; y <= 12; ++y) {
                for (int x = 3; x <= 11; ++x) {
                    byte piecesIndex = data[Position.COORD_XY(x, y)];
                    if (CChessUtil.isRed(piecesIndex) || CChessUtil.isBlack(piecesIndex)) {
                        CChessPiecesModel chessPiecesModel = this.chessPiecesModels[piecesIndex];
                        chessPiecesModel.renderToBuffer(poseStack, piecesBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                        if (selectX == x && selectY == y) {
                            this.selectedModels.renderToBuffer(poseStack, piecesBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                        }
                    }
                    poseStack.method_22904(0.304, 0.0, 0.0);
                }
                poseStack.method_22904(-2.7359999999999998, 0.0, -0.304);
            }
            poseStack.method_22909();
        }
    }

    private void renderChessboard(class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, class_2350 facing) {
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.5, 0.5);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
        poseStack.method_22907(class_7833.field_40715.rotationDegrees((float)(facing.method_10161() * 90)));
        if (facing == class_2350.field_11035 || facing == class_2350.field_11043) {
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
        }
        class_4588 checkerBoardBuff = bufferIn.getBuffer(class_1921.method_23578((class_2960)TEXTURE));
        this.chessModel.method_60879(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn);
        poseStack.method_22909();
    }

    private boolean inRenderDistance(TileEntityCChess chess, int distance) {
        class_2338 pos = chess.method_11016();
        return this.dispatcher.field_4344.method_19326().method_1028((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) < (double)(distance * distance);
    }

    public boolean shouldRenderOffScreen(TileEntityCChess te) {
        return true;
    }
}

