/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.models;

import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.model.PlayerMaidModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8685;

@Environment(value=EnvType.CLIENT)
public final class PlayerMaidModels {
    private static final Cache<String, GameProfile> GAME_PROFILE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static final GameProfile EMPTY_GAME_PROFILE = new GameProfile(UUID.randomUUID(), "alex");
    private static final PlayerMaidModel PLAYER_MAID_MODEL = new PlayerMaidModel(false);
    private static final PlayerMaidModel PLAYER_MAID_MODEL_SLIM = new PlayerMaidModel(true);
    private static final List<class_2960> PLAYER_MAID_ANIMATION_RES = Lists.newArrayList((Object[])new class_2960[]{class_2960.method_60655((String)"touhou_little_maid", (String)"animation/maid/default/head/default.js"), class_2960.method_60655((String)"touhou_little_maid", (String)"animation/maid/default/head/beg.js"), class_2960.method_60655((String)"touhou_little_maid", (String)"animation/maid/default/leg/default.js"), class_2960.method_60655((String)"touhou_little_maid", (String)"animation/maid/player/arm/default.js"), class_2960.method_60655((String)"touhou_little_maid", (String)"animation/maid/default/arm/swing.js"), class_2960.method_60655((String)"touhou_little_maid", (String)"animation/maid/player/sit/default.js")});
    private static final class_2960 TEXTURE_ALEX = class_2960.method_60656((String)"textures/entity/alex.png");
    private static final List<Object> PLAYER_MAID_ANIMATIONS = Lists.newArrayList();
    private static MaidModelInfo playerMaidInfo;
    private static class_2960 playerSkin;

    public static void reload() {
        PLAYER_MAID_ANIMATIONS.clear();
        for (class_2960 res : PLAYER_MAID_ANIMATION_RES) {
            PLAYER_MAID_ANIMATIONS.add(InnerAnimation.get(res));
        }
        playerMaidInfo = new MaidModelInfo(){

            @Override
            public class_2960 getTexture() {
                return playerSkin;
            }
        };
    }

    public static BedrockModel<class_1308> getPlayerMaidModel(String name) {
        class_8685 skin;
        GameProfile newProfile = null;
        class_310 minecraft = class_310.method_1551();
        try {
            newProfile = (GameProfile)GAME_PROFILE_CACHE.get((Object)name, () -> {
                class_2631.method_52580((String)name).thenApply(gameProfile -> {
                    GameProfile profile = gameProfile.orElse(EMPTY_GAME_PROFILE);
                    GAME_PROFILE_CACHE.put((Object)name, (Object)profile);
                    return profile;
                });
                return EMPTY_GAME_PROFILE;
            });
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (newProfile != null && (skin = minecraft.method_1582().method_52862(newProfile)).comp_1629() == class_8685.class_7920.field_41122) {
            return PLAYER_MAID_MODEL_SLIM;
        }
        return PLAYER_MAID_MODEL;
    }

    public static List<Object> getPlayerMaidAnimations() {
        return PLAYER_MAID_ANIMATIONS;
    }

    public static MaidModelInfo getPlayerMaidInfo(String name) {
        playerSkin = PlayerMaidModels.getPlayerSkin(name);
        return playerMaidInfo;
    }

    public static class_2960 getPlayerSkin(String name) {
        GameProfile newProfile = null;
        class_310 minecraft = class_310.method_1551();
        try {
            newProfile = (GameProfile)GAME_PROFILE_CACHE.get((Object)name, () -> {
                class_2631.method_52580((String)name).thenApply(gameProfile -> {
                    GameProfile profile = gameProfile.orElse(EMPTY_GAME_PROFILE);
                    GAME_PROFILE_CACHE.put((Object)name, (Object)profile);
                    return profile;
                });
                return EMPTY_GAME_PROFILE;
            });
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (newProfile != null) {
            class_8685 skin = minecraft.method_1582().method_52862(newProfile);
            return skin.comp_1626();
        }
        return TEXTURE_ALEX;
    }
}

